/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.opencard.terminal.pcsc10;

import com.ibm.opencard.terminal.pcsc10.OCFPCSC1;
import com.ibm.opencard.terminal.pcsc10.PcscException;
import com.ibm.opencard.terminal.pcsc10.PcscReaderState;
import java.util.Properties;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;
import opencard.opt.terminal.AbstractLockableTerminal;
import opencard.opt.terminal.TerminalCommand;
import opencard.opt.terminal.TerminalLockedException;

public final class Pcsc10LockableTerminal
extends AbstractLockableTerminal
implements TerminalCommand,
Pollable {
    private Tracer itracer = new Tracer((Object)this, class$com$ibm$opencard$terminal$pcsc10$Pcsc10LockableTerminal != null ? class$com$ibm$opencard$terminal$pcsc10$Pcsc10LockableTerminal : (class$com$ibm$opencard$terminal$pcsc10$Pcsc10LockableTerminal = Pcsc10LockableTerminal.class$("com.ibm.opencard.terminal.pcsc10.Pcsc10LockableTerminal")));
    private OCFPCSC1 pcsc;
    private int context = 0;
    private boolean closed;
    private boolean locked = false;
    private boolean cardInserted;
    private int cardHandle = 0;
    private static final int SCARD_STATE_MUTE = 512;
    private static final int SCARD_STATE_PRESENT = 32;
    private CardID cid = null;
    private byte[] cachedATR;
    static /* synthetic */ Class class$com$ibm$opencard$terminal$pcsc10$Pcsc10LockableTerminal;

    protected Pcsc10LockableTerminal(String string, String string2, String string3) throws CardTerminalException {
        super(string, string2, string3);
        try {
            this.itracer.debug("Pcsc10LockableTerminal", "connect to PCSC 1.0 resource manager");
            OCFPCSC1.loadLib();
            this.pcsc = new OCFPCSC1();
            this.context = this.pcsc.SCardEstablishContext(0);
            this.itracer.debug("Pcsc10LockableTerminal", "Driver initialized");
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
        this.addSlots(1);
    }

    private void cardConnect() throws CardTerminalException {
        Integer n = new Integer(0);
        try {
            this.itracer.debug("cardConnect", "connect to smartcard");
            this.cardHandle = this.pcsc.SCardConnect(this.context, this.getName(), 1, 3, n);
            this.itracer.debug("cardConnect", "got card handle: " + this.cardHandle);
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
    }

    private void cardDisconnect(int n) throws CardTerminalException {
        block5: {
            block4: {
                if (this.cardHandle == 0) break block4;
                try {
                    try {
                        this.itracer.debug("cardDisconnect", "disconnect smartcard - cardHandle=" + this.cardHandle);
                        this.pcsc.SCardDisconnect(this.cardHandle, n);
                    }
                    catch (PcscException pcscException) {
                        throw this.translatePcscException(pcscException);
                    }
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.itracer.debug("cardDisconnect", "invalidate card handle");
                    this.cardHandle = 0;
                    throw throwable;
                }
                this.itracer.debug("cardDisconnect", "invalidate card handle");
                this.cardHandle = 0;
                break block5;
            }
            this.itracer.debug("cardDisconnect", "cardHandle already 0 - disconnect impossible");
        }
    }

    protected void cardRemoved(int n) {
        block2: {
            super.cardRemoved(n);
            if (this.locked) break block2;
            try {
                this.cardDisconnect(0);
            }
            catch (CardTerminalException cardTerminalException) {}
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() throws CardTerminalException {
        if (!this.closed) {
            this.itracer.debug("close", "disable polling");
            CardTerminalRegistry.getRegistry().removePollable((Pollable)this);
            this.closed = true;
            if (this.cardInserted && this.cid != null) {
                this.itracer.debug("close", "card inserted - try to power down card");
                this.cid = null;
                this.cardDisconnect(3);
            } else {
                this.itracer.debug("close", "no card inserted");
            }
            try {
                this.itracer.debug("close", "release context");
                this.pcsc.SCardReleaseContext(this.context);
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
        } else {
            this.itracer.debug("close", "Terminal already closed!");
            throw new CardTerminalException("Pcsc10LockableTerminal: already closed");
        }
    }

    private int getCardHandle() {
        return this.cardHandle;
    }

    public CardID getCardID(int n) throws CardTerminalException {
        if (n != 0) {
            throw new CardTerminalException("Invalid slot number: " + n);
        }
        return this.cid;
    }

    public CardID getCardID(int n, int n2) throws CardTerminalException {
        return this.getCardID(n);
    }

    protected void internalCloseSlotChannel(SlotChannel slotChannel) throws CardTerminalException {
        super.internalCloseSlotChannel(slotChannel);
        if (!this.locked) {
            this.cardDisconnect(0);
        }
    }

    protected Properties internalFeatures(Properties properties) {
        return properties;
    }

    protected synchronized void internalLock() throws CardTerminalException {
        this.internalLockSlot(0);
    }

    protected synchronized void internalLockSlot(int n) throws CardTerminalException {
        this.readerConnect();
        this.locked = true;
    }

    protected CardID internalReset(int n, int n2) throws CardTerminalException {
        if (this.isCardConnected()) {
            this.itracer.debug("internalReset", "cardHandle exists - try reconnect");
            this.cid = null;
            Integer n3 = new Integer(0);
            try {
                this.pcsc.SCardReconnect(this.cardHandle, 1, 3, 1, n3);
                this.cid = new CardID((CardTerminal)this, 0, this.cachedATR);
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
            return this.getCardID(n);
        }
        this.itracer.debug("internalReset", "card reset failed - no card inserted");
        return null;
    }

    protected ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        if (n != 0) {
            throw new CardTerminalException("Invalid slot: " + n);
        }
        this.itracer.debug("internalSendAPDU", "sending " + commandAPDU);
        byte[] byArray = null;
        try {
            byArray = this.pcsc.SCardTransmit(this.cardHandle, commandAPDU.getBytes());
        }
        catch (PcscException pcscException) {
            if (pcscException.returnCode() == 121) {
                this.internalReset(0, 5000);
                throw new CardTerminalException("PC/SC Error: semaphore timeout - perhaps forbidden or wrong card command.");
            }
            throw this.translatePcscException(pcscException);
        }
        ResponseAPDU responseAPDU = new ResponseAPDU(byArray);
        this.itracer.debug("internalSendAPDU", "receiving " + responseAPDU);
        return responseAPDU;
    }

    protected synchronized void internalUnlock() throws CardTerminalException {
        this.internalUnlockSlot(0);
    }

    protected synchronized void internalUnlockSlot(int n) throws CardTerminalException {
        this.cardDisconnect(0);
        this.locked = false;
    }

    private boolean isCardConnected() {
        return this.cardHandle != 0 && this.cardInserted;
    }

    public synchronized boolean isCardPresent(int n) throws CardTerminalException {
        if (!this.closed) {
            if (n != 0) {
                throw new CardTerminalException("Invalid Slot number: " + n);
            }
            boolean bl = this.pcscIsCardPresent();
            if (bl != this.cardInserted && this.locked) {
                this.updateConnectionMode(bl);
            }
            return bl;
        }
        return false;
    }

    protected synchronized void lockableOpenSlotChannel(int n) throws CardTerminalException {
        if (!this.locked) {
            this.cardConnect();
        }
    }

    public void open() throws CardTerminalException {
        CardTerminalRegistry.getRegistry().addPollable((Pollable)this);
        this.closed = false;
    }

    private boolean pcscIsCardPresent() throws CardTerminalException {
        PcscReaderState[] pcscReaderStateArray = new PcscReaderState[]{new PcscReaderState()};
        pcscReaderStateArray[0].CurrentState = 0;
        pcscReaderStateArray[0].Reader = this.getName();
        try {
            this.pcsc.SCardGetStatusChange(this.context, 1, pcscReaderStateArray);
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
        if ((pcscReaderStateArray[0].EventState & 0x200) != 0 && (pcscReaderStateArray[0].EventState & 0x20) != 0) {
            throw new CardTerminalException("Card present but unresponsive in slot 0");
        }
        if ((pcscReaderStateArray[0].EventState & 4) != 0 || (pcscReaderStateArray[0].EventState & 8) != 0) {
            byte[] byArray = new byte[1];
            try {
                byArray = this.pcsc.SCardGetAttrib(this.cardHandle, 590592);
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
            if (byArray[0] == 2) {
                this.itracer.debug("isCardPresent", "SCardGetAttrib: card present");
                return true;
            }
            this.itracer.debug("isCardPresent", "SCardGetAttrib: no card present " + byArray[0]);
            return false;
        }
        this.cachedATR = pcscReaderStateArray[0].ATR;
        if (this.cachedATR != null) {
            return this.cachedATR.length > 0;
        }
        return false;
    }

    public void poll() throws CardTerminalException {
        block5: {
            if (this.closed) break block5;
            try {
                boolean bl = this.isCardPresent(0);
                if (this.cardInserted != bl) {
                    this.itracer.debug("poll", "status change");
                    this.cardInserted ^= true;
                    if (this.cardInserted) {
                        this.cid = new CardID((CardTerminal)this, 0, this.cachedATR);
                        this.cardInserted(0);
                    } else {
                        this.cardRemoved(0);
                    }
                    break block5;
                }
                this.itracer.debug("poll", "no status change");
            }
            catch (CardTerminalException cardTerminalException) {
                this.itracer.debug("poll", (Throwable)cardTerminalException);
                this.cardInserted(0);
            }
        }
    }

    private void readerConnect() throws CardTerminalException {
        Integer n = new Integer(0);
        try {
            this.itracer.debug("readerConnect", "connect to reader");
            this.cardHandle = this.pcsc.SCardConnect(this.context, this.getName(), 3, 0, n);
            this.itracer.debug("readerConnect", "got card handle: " + this.cardHandle);
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
    }

    public byte[] sendTerminalCommand(byte[] byArray) throws CardTerminalException {
        return this.sendTerminalCommand(byArray, null);
    }

    public byte[] sendTerminalCommand(byte[] byArray, Object object) throws CardTerminalException {
        if (this.cardHandle == 0) {
            throw new CardTerminalException("no card present", (CardTerminal)this);
        }
        if (this.locked && this.getTerminalLockHandle() != object && this.getSlotLockHandle(0) != object) {
            throw new TerminalLockedException("terminal locked, invalid lock handle", (CardTerminal)this);
        }
        try {
            byte[] byArray2 = this.pcsc.SCardControl(this.cardHandle, 0, byArray);
            return byArray2;
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
    }

    protected CardTerminalException translatePcscException(PcscException pcscException) {
        return new CardTerminalException("Pcsc10LockableTerminal: " + pcscException.getMessage(), (CardTerminal)this);
    }

    private void updateConnectionMode(boolean bl) throws CardTerminalException {
        try {
            Integer n = new Integer(0);
            if (bl) {
                this.itracer.debug("isCardPresent", "status change, reconnecting share exclusive");
                this.pcsc.SCardReconnect(this.cardHandle, 1, 3, 2, n);
                this.cachedATR = this.pcsc.SCardGetAttrib(this.cardHandle, 590595);
            } else {
                this.itracer.debug("isCardPresent", "status change, reconnecting share direct");
                this.pcsc.SCardReconnect(this.cardHandle, 3, 0, 0, n);
                this.cachedATR = null;
            }
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
    }
}

