/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.opencard.terminal.pcsc10;

import com.ibm.opencard.terminal.pcsc10.OCFPCSC1;
import com.ibm.opencard.terminal.pcsc10.Pcsc10CardTerminalFactory;
import com.ibm.opencard.terminal.pcsc10.PcscException;
import com.ibm.opencard.terminal.pcsc10.PcscReaderState;
import java.util.Hashtable;
import java.util.Properties;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.SystemAccess;
import opencard.core.util.Tracer;
import opencard.opt.terminal.PowerManagementInterface;
import opencard.opt.terminal.TerminalCommand;

public class Pcsc10CardTerminal
extends CardTerminal
implements TerminalCommand,
Pollable,
PowerManagementInterface {
    private Tracer itracer = new Tracer((Object)this, class$com$ibm$opencard$terminal$pcsc10$Pcsc10CardTerminal != null ? class$com$ibm$opencard$terminal$pcsc10$Pcsc10CardTerminal : (class$com$ibm$opencard$terminal$pcsc10$Pcsc10CardTerminal = Pcsc10CardTerminal.class$("com.ibm.opencard.terminal.pcsc10.Pcsc10CardTerminal")));
    private OCFPCSC1 pcsc;
    private Pcsc10CardTerminalFactory PCSCfactory = null;
    private int context = 0;
    private boolean closed;
    private boolean cardInserted = false;
    private boolean CachedCardStatus = false;
    private static final String DATE = "October 31, 2000";
    private static final String VERSION = "Release v2.0";
    private int cardHandle = 0;
    private static final int SCARD_STATE_MUTE = 512;
    private static final int SCARD_STATE_PRESENT = 32;
    private CardID cid = null;
    private byte[] cachedATR;
    private int le = 0;
    private int lc = 0;
    private int lenbuf = 0;
    private int caseAPDU = 0;
    private boolean TPDU_Uses_ISO = true;
    private int protocolUsed = 0;
    private int portMode = 0;
    private int port = 0;
    static /* synthetic */ Class class$com$ibm$opencard$terminal$pcsc10$Pcsc10CardTerminal;

    protected Pcsc10CardTerminal(String string, String string2, String string3, Pcsc10CardTerminalFactory pcsc10CardTerminalFactory, int n) throws CardTerminalException {
        super(string, string2, string3);
        this.portMode = string3.equals("SHARED") ? 2 : 1;
        try {
            this.itracer.debug("Pcsc10CardTerminal", "connect to PCSC 1.0 resource manager");
            OCFPCSC1.loadLib();
            this.pcsc = new OCFPCSC1();
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
        this.PCSCfactory = pcsc10CardTerminalFactory;
        this.port = n;
        this.addSlots(1);
    }

    protected boolean UpdateCardStatus(int n) throws CardTerminalException {
        boolean bl = false;
        if (!this.closed) {
            if (n != 0) {
                throw new CardTerminalException("Invalid Slot number: " + n);
            }
            PcscReaderState[] pcscReaderStateArray = new PcscReaderState[]{new PcscReaderState()};
            pcscReaderStateArray[0].CurrentState = 0;
            pcscReaderStateArray[0].Reader = this.getName();
            try {
                this.pcsc.SCardGetStatusChange(this.context, 1, pcscReaderStateArray);
                if ((pcscReaderStateArray[0].EventState & 0x200) != 0 && (pcscReaderStateArray[0].EventState & 0x20) != 0) {
                    throw new CardTerminalException("Card present but unresponsive in slot " + n);
                }
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
            this.cachedATR = pcscReaderStateArray[0].ATR;
            if (this.cachedATR != null) {
                if (this.cachedATR.length > 0) {
                    int n2 = 1;
                    while ((this.cachedATR[n2] & 0xFFFFFF80) != 0) {
                        int n3 = 0;
                        int n4 = 16;
                        int n5 = 0;
                        while (n5 < 4) {
                            if ((this.cachedATR[n2] & n4) != 0) {
                                ++n3;
                            }
                            n4 <<= 1;
                            ++n5;
                        }
                        n2 += n3;
                        if (bl) continue;
                        bl = true;
                        this.protocolUsed = this.cachedATR[n2] & 0xF;
                        break;
                    }
                    this.CachedCardStatus = true;
                    return true;
                }
                this.CachedCardStatus = false;
                return false;
            }
            this.CachedCardStatus = false;
            return false;
        }
        return false;
    }

    private void cardConnect() throws CardTerminalException {
        Integer n = new Integer(0);
        try {
            this.itracer.debug("cardConnect", "connect to smartcard");
            this.cardHandle = this.pcsc.SCardConnect(this.context, this.getName(), this.portMode, 3, n);
            this.itracer.debug("cardConnect", "got card handle: " + this.cardHandle);
            if (this.cardHandle == 0) {
                throw new CardTerminalException("No cardHandle present.  ", (CardTerminal)this);
            }
            this.UpdateCardStatus(0);
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
    }

    private void cardDisconnect(int n) throws CardTerminalException {
        block5: {
            block4: {
                if (this.cardHandle == 0) break block4;
                try {
                    try {
                        this.itracer.debug("cardDisconnect", "disconnect smartcard - cardHandle=" + this.cardHandle);
                        this.pcsc.SCardDisconnect(this.cardHandle, n);
                    }
                    catch (PcscException pcscException) {
                        throw this.translatePcscException(pcscException);
                    }
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.itracer.debug("cardDisconnect", "invalidate card handle");
                    this.cardHandle = 0;
                    throw throwable;
                }
                this.itracer.debug("cardDisconnect", "invalidate card handle");
                this.cardHandle = 0;
                break block5;
            }
            this.itracer.debug("cardDisconnect", "cardHandle already 0 - disconnect impossible");
        }
    }

    protected void cardRemoved(int n) {
        super.cardRemoved(n);
        try {
            this.cardDisconnect(0);
        }
        catch (CardTerminalException cardTerminalException) {}
    }

    private void checkNonNullResponse(byte[] byArray) throws CardTerminalException {
        if (byArray == null) {
            throw new CardTerminalException("No response from reader. ", (CardTerminal)this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() throws CardTerminalException {
        this.PCSCfactory.close(this.port);
        if (!this.closed) {
            this.itracer.debug("close", "disable polling");
            CardTerminalRegistry.getRegistry().removePollable((Pollable)this);
            this.closed = true;
            if (this.cardInserted && this.cid != null) {
                this.itracer.debug("close", "card inserted - try to power down card");
                this.cid = null;
                this.powerDownCard(0, -1);
            } else {
                this.itracer.debug("close", "no card inserted");
            }
            try {
                this.itracer.debug("close", "release context");
                this.pcsc.SCardReleaseContext(this.context);
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
        } else {
            this.itracer.debug("close", "Terminal already closed!");
            throw new CardTerminalException("Pcsc10CardTerminal: already closed");
        }
    }

    protected int convertByte(int n) {
        int n2 = n & 0x7F;
        if ((n & 0x80) == 128) {
            n2 += 128;
        }
        return n2;
    }

    private int getCardHandle() {
        return this.cardHandle;
    }

    public CardID getCardID(int n) throws CardTerminalException {
        if (n != 0) {
            throw new CardTerminalException("Invalid slot number: " + n);
        }
        if (this.CachedCardStatus && this.cid != null) {
            return this.cid;
        }
        return null;
    }

    public CardID getCardID(int n, int n2) throws CardTerminalException {
        return this.getCardID(n);
    }

    protected void internalCloseSlotChannel(SlotChannel slotChannel) throws CardTerminalException {
        super.internalCloseSlotChannel(slotChannel);
        this.powerDownCard(0, -1);
    }

    protected Properties internalFeatures(Properties properties) {
        ((Hashtable)properties).put("Release Date: ", DATE);
        ((Hashtable)properties).put("PCSC CardTerminal Version: ", VERSION);
        ((Hashtable)properties).put("Reader Name: ", this.getName());
        ((Hashtable)properties).put("Reader Type: ", this.getType());
        return properties;
    }

    protected synchronized void internalOpenSlotChannel(int n) throws CardTerminalException {
        this.itracer.debug("internalOpenSlotChannel", "CONNECT CARD:");
        this.powerUpCard(0, -1);
    }

    protected CardID internalReset(int n, int n2) throws CardTerminalException {
        if (this.CachedCardStatus) {
            this.itracer.debug("internalReset", "cardHandle exists - try reconnect");
            this.cid = null;
            Integer n3 = new Integer(0);
            try {
                if (this.cardHandle != 0) {
                    this.pcsc.SCardReconnect(this.cardHandle, this.portMode, 3, 1, n3);
                } else {
                    this.cardHandle = this.pcsc.SCardConnect(this.context, this.getName(), this.portMode, 3, n3);
                }
                this.UpdateCardStatus(0);
                if (this.cachedATR == null) {
                    throw new CardTerminalException("No ATR present. Card badly inserted? ", (CardTerminal)this);
                }
                this.cid = new CardID((CardTerminal)this, 0, this.cachedATR);
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
            return this.getCardID(n, n2);
        }
        this.itracer.debug("internalReset", "card reset failed - no card inserted");
        return null;
    }

    /*
     * Exception decompiling
     */
    protected ResponseAPDU internalSendAPDU(int var1_1, CommandAPDU var2_2, int var3_3) throws CardTerminalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isCardConnected(int n) throws CardTerminalException {
        boolean bl = false;
        try {
            bl = this.isCardPresent(n);
            if (bl & this.cardHandle == 0) {
                this.cardConnect();
            }
        }
        catch (CardTerminalException cardTerminalException) {
            throw new CardTerminalException(cardTerminalException.getMessage());
        }
        return bl;
    }

    public synchronized boolean isCardPresent(int n) throws CardTerminalException {
        return this.CachedCardStatus;
    }

    public boolean isISOTPDU() throws CardTerminalException {
        return this.TPDU_Uses_ISO;
    }

    public void open() throws CardTerminalException {
        try {
            this.itracer.debug("Pcsc10CardTerminal", "connect to PCSC 1.0 resource manager");
            this.context = this.pcsc.SCardEstablishContext(0);
            this.itracer.debug("Pcsc10CardTerminal", "Driver initialized");
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
        try {
            String string = SystemAccess.getSystemAccess().getProperty("Uses_Standard_ISO_TPDU");
            if (string.equals("false")) {
                this.setISOTPDUMode(false);
            } else {
                this.setISOTPDUMode(true);
            }
            if (!this.TPDU_Uses_ISO) {
                System.out.println("TPDU Not Used\n");
            } else {
                System.out.println("Uses ISO TPDU\n");
            }
        }
        catch (Exception exception) {
            this.setISOTPDUMode(true);
            System.out.println("Uses ISOTPDU\n");
        }
        this.closed = false;
        CardTerminalRegistry.getRegistry().addPollable((Pollable)this);
    }

    public void poll() throws CardTerminalException {
        block5: {
            if (this.closed) break block5;
            this.UpdateCardStatus(0);
            try {
                boolean bl = this.isCardPresent(0);
                if (this.cardInserted != bl) {
                    this.itracer.debug("poll", "status change");
                    this.cardInserted ^= true;
                    if (this.cardInserted) {
                        this.cid = new CardID((CardTerminal)this, 0, this.cachedATR);
                        this.cardInserted(0);
                    } else {
                        this.cardRemoved(0);
                        this.cachedATR = null;
                        this.cid = null;
                    }
                    break block5;
                }
                this.itracer.debug("poll", "no status change");
            }
            catch (CardTerminalException cardTerminalException) {
                this.itracer.debug("poll", (Throwable)cardTerminalException);
                this.cardInserted(0);
            }
        }
    }

    public void powerDownCard(int n, int n2) throws CardTerminalException {
        this.cardDisconnect(2);
    }

    public void powerUpCard(int n, int n2) throws CardTerminalException {
        try {
            this.powerUpCard(n, n2, 0);
        }
        catch (Exception exception) {
            throw new CardTerminalException(exception.getMessage());
        }
    }

    public byte[] powerUpCard(int n, int n2, int n3) throws CardTerminalException {
        if (this.CachedCardStatus) {
            this.itracer.debug("PowerUpCard", "cardHandle exists - try reconnect");
            Integer n4 = new Integer(0);
            try {
                if (this.cardHandle != 0) {
                    this.pcsc.SCardReconnect(this.cardHandle, this.portMode, 3, 2, n4);
                } else {
                    this.cardHandle = this.pcsc.SCardConnect(this.context, this.getName(), this.portMode, 3, n4);
                }
                this.UpdateCardStatus(0);
                if (this.cachedATR == null) {
                    throw new CardTerminalException("No ATR present. Card badly inserted? ", (CardTerminal)this);
                }
                this.cid = new CardID((CardTerminal)this, 0, this.cachedATR);
            }
            catch (PcscException pcscException) {
                throw this.translatePcscException(pcscException);
            }
            return this.cachedATR;
        }
        this.itracer.debug("powerUpCard", "card reset failed - no card inserted");
        return null;
    }

    public byte[] sendTerminalCommand(byte[] byArray) throws CardTerminalException {
        byte[] byArray2 = null;
        if (this.cardHandle == 0) {
            throw new CardTerminalException("no card present", (CardTerminal)this);
        }
        try {
            byArray2 = this.pcsc.SCardControl(this.cardHandle, 0, byArray);
            this.checkNonNullResponse(byArray2);
            return byArray2;
        }
        catch (PcscException pcscException) {
            throw this.translatePcscException(pcscException);
        }
    }

    public void setISOTPDUMode(boolean bl) throws CardTerminalException {
        this.TPDU_Uses_ISO = bl;
    }

    protected CardTerminalException translatePcscException(PcscException pcscException) {
        return new CardTerminalException("Pcsc10CardTerminal: " + pcscException.getMessage(), (CardTerminal)this);
    }
}

