/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.terminal.protocol;

import opencard.core.util.HexString;
import opencard.opt.terminal.protocol.T1BlockEDCErrorException;
import opencard.opt.terminal.protocol.T1BlockLengthException;
import opencard.opt.terminal.protocol.T1BlockNotImplementedFeatureException;
import opencard.opt.terminal.protocol.T1DataPacketTooLongException;
import opencard.opt.terminal.protocol.T1Exception;
import opencard.opt.terminal.protocol.T1UnknownBlockException;

public class T1Block {
    public static final int EDC_LDR = 1;
    public static final int EDC_CRC = 2;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_EDC = 1;
    public static final int ERROR_OTHER = 2;
    public static final int S_RESYNCH_REQUEST = 0;
    public static final int S_RESYNCH_RESPONSE = 32;
    public static final int S_IFS_REQUEST = 1;
    public static final int S_IFS_RESPONSE = 33;
    public static final int S_ABORT_REQUEST = 2;
    public static final int S_ABORT_RESPONSE = 34;
    public static final int S_WTX_REQUEST = 3;
    public static final int S_WTX_RESPONSE = 35;
    public static final int S_VPP_STATE_ERROR_RESPONSE = 36;
    public static final int I_BLOCK = 0;
    public static final int R_BLOCK = 128;
    public static final int S_BLOCK = 192;
    private byte NAD;
    private byte PCB;
    private int LEN;
    private byte[] DAT;
    private int EDC;
    private int algForEDC;

    public T1Block(int n, int n2, int n3, byte[] byArray, int n4) throws T1BlockLengthException, T1BlockEDCErrorException {
        this.NAD = (byte)(((n2 & 7) << 4) + (n & 7));
        this.PCB = (byte)n3;
        if (byArray != null) {
            if (byArray.length > 254) {
                throw new T1DataPacketTooLongException("info-field of I-BLOCK must not be greater than 254 bytes");
            }
            this.LEN = byArray.length;
        } else {
            this.LEN = 0;
        }
        this.DAT = byArray;
        this.algForEDC = n4;
        this.EDC = this.calcEDC();
    }

    public T1Block(byte[] byArray, int n) throws T1BlockLengthException, T1BlockEDCErrorException {
        this.NAD = byArray[0];
        this.PCB = byArray[1];
        this.LEN = byArray[2] & 0xFF;
        this.algForEDC = n;
        if (byArray.length == this.LEN + 4) {
            this.DAT = new byte[this.LEN];
            System.arraycopy(byArray, 3, this.DAT, 0, this.LEN);
            this.EDC = byArray[byArray.length - 1];
        } else if (byArray.length == this.LEN + 5) {
            this.disableCRC();
            this.DAT = new byte[this.LEN];
            System.arraycopy(byArray, 3, this.DAT, 0, this.LEN);
            this.EDC = (byArray[byArray.length - 2] << 8) + byArray[byArray.length - 1];
        } else {
            throw new T1BlockLengthException("block length mismatch detected");
        }
        if (!this.checkEDC()) {
            throw new T1BlockEDCErrorException("EDC error detected");
        }
    }

    public int calcEDC() {
        int n = 0;
        this.disableCRC();
        if (this.algForEDC == 1) {
            n = 0;
            n = this.NAD ^ this.PCB ^ (byte)this.LEN;
            if (this.DAT != null) {
                int n2 = 0;
                while (n2 < this.DAT.length) {
                    n ^= this.DAT[n2];
                    ++n2;
                }
            }
        }
        return n;
    }

    public boolean checkEDC() {
        return this.EDC == this.calcEDC();
    }

    public byte[] getBlock() {
        byte[] byArray;
        this.disableCRC();
        if (this.DAT != null) {
            byArray = new byte[this.DAT.length + 4];
            System.arraycopy(this.DAT, 0, byArray, 3, this.DAT.length);
        } else {
            byArray = new byte[4];
        }
        byArray[0] = this.NAD;
        byArray[1] = this.PCB;
        byArray[2] = (byte)this.LEN;
        byArray[byArray.length - 1] = (byte)(0xFF & this.EDC);
        return byArray;
    }

    public int getBlockType() throws T1UnknownBlockException {
        if ((~this.PCB & 0x80) != 0) {
            return 0;
        }
        if ((this.PCB & 0xC0) == 128) {
            return 128;
        }
        if ((this.PCB & 0xC0) == 192) {
            return 192;
        }
        throw new T1UnknownBlockException();
    }

    public byte getNAD() {
        return this.NAD;
    }

    public int getSourceID() {
        return this.getNAD() & 7;
    }

    public int getDestID() {
        return this.getNAD() >> 4 & 7;
    }

    public byte getPCB() {
        return this.PCB;
    }

    public int getLEN() {
        return this.LEN;
    }

    public byte[] getDATA() {
        return this.DAT;
    }

    public int getEDC() {
        return this.EDC;
    }

    public int getEDCAlgorithm() {
        return this.algForEDC;
    }

    public int getControlBits() throws T1Exception {
        switch (this.getBlockType()) {
            case 0: {
                return this.getPCB() & 0x7F;
            }
            case 128: 
            case 192: {
                return this.getPCB() & 0x3F;
            }
        }
        return 0;
    }

    private void disableCRC() {
        if (this.algForEDC == 2) {
            throw new T1BlockNotImplementedFeatureException("CRC-algorithm is not implemented!");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("T1-BLOCK\n--------\n");
        stringBuffer.append("sourceID   = " + this.getSourceID() + "\n");
        stringBuffer.append("destID     = " + this.getDestID() + "\n");
        stringBuffer.append("PCB        = " + HexString.hexify((int)this.PCB) + " (" + Integer.toBinaryString(this.PCB & 0xFF) + ")\n");
        try {
            int n = this.getBlockType();
            switch (n) {
                case 0: {
                    stringBuffer.append("blocktype  = I-BLOCK\n");
                    stringBuffer.append("  N(S)     = " + (this.PCB >> 6) + "\n");
                    stringBuffer.append("  chaining = " + ((this.PCB & 0x20) == 32 ? "yes\n" : "no\n"));
                    stringBuffer.append("  infolen  = " + this.LEN + "\n");
                    if (this.getLEN() <= 0) break;
                    stringBuffer.append("  infodata = " + HexString.hexify((byte[])this.DAT) + "\n");
                    break;
                }
                case 128: {
                    stringBuffer.append("blocktype  = R-BLOCK\n");
                    stringBuffer.append("  status   = ");
                    switch (this.PCB & 0xF) {
                        case 0: {
                            stringBuffer.append("error-free\n");
                            break;
                        }
                        case 1: {
                            stringBuffer.append("EDC or parity error\n");
                            break;
                        }
                        case 2: {
                            stringBuffer.append("other errors\n");
                            break;
                        }
                        default: {
                            stringBuffer.append("unknown option\n");
                        }
                    }
                    stringBuffer.append("  N(R)     = " + (this.PCB >> 4 & 1) + "\n");
                    break;
                }
                case 192: {
                    stringBuffer.append("blocktype  = S-BLOCK\n");
                    switch (this.PCB & 0x3F) {
                        case 0: {
                            stringBuffer.append("  status   = RESYNCH request\n");
                            break;
                        }
                        case 32: {
                            stringBuffer.append("  status   = RESYNCH response\n");
                            break;
                        }
                        case 1: {
                            stringBuffer.append("  status   = IFS request\n");
                            break;
                        }
                        case 33: {
                            stringBuffer.append("  status   = IFS response\n");
                            break;
                        }
                        case 2: {
                            stringBuffer.append("  status   = ABORT request\n");
                            break;
                        }
                        case 34: {
                            stringBuffer.append("  status   = ABORT response\n");
                            break;
                        }
                        case 3: {
                            stringBuffer.append("  status   = WTX request\n");
                            break;
                        }
                        case 35: {
                            stringBuffer.append("  status   = WTX response\n");
                            break;
                        }
                        case 36: {
                            stringBuffer.append("  status   = VPP state error response\n");
                            break;
                        }
                    }
                    stringBuffer.append("  infolen  = " + this.LEN + "\n");
                    if (this.getLEN() <= 0) break;
                    stringBuffer.append("  infodata = " + HexString.hexify((byte[])this.DAT) + "\n");
                    break;
                }
            }
            stringBuffer.append("EDC algrthm= " + (this.algForEDC == 1 ? "LDR\n" : "CRC16\n"));
            stringBuffer.append("saved EDC  = " + (this.algForEDC == 1 ? HexString.hexify((int)this.EDC) : HexString.hexifyShort((int)this.EDC)));
            stringBuffer.append(" (calculated: " + (this.algForEDC == 1 ? HexString.hexify((int)this.calcEDC()) : HexString.hexifyShort((int)this.calcEDC())) + ")\n");
            stringBuffer.append("raw bytes  = " + HexString.hexify((byte[])this.getBlock()) + "\n");
        }
        catch (T1UnknownBlockException t1UnknownBlockException) {
            stringBuffer.append("blocktype= UNKNOWN");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public int getSourceAddress() {
        return this.getNAD() & 0xF;
    }

    public int getDestinationAddress() {
        return this.getNAD() >> 4 & 0xF;
    }

    public int getRequestedSequenceNumber() throws T1Exception {
        return this.getControlBits() >> 4;
    }
}

