/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.terminal;

import opencard.core.terminal.APDU;
import opencard.core.terminal.CommandAPDU;

public class ISOCommandAPDU
extends CommandAPDU {
    protected int lc;
    protected int le;
    public static final int CASE_1 = 2;
    public static final int CASE_2S = 8;
    public static final int CASE_2E = 12;
    public static final int CASE_3S = 32;
    public static final int CASE_3E = 48;
    public static final int CASE_4S = 128;
    public static final int CASE_4E = 192;
    public static final int CLASS = 0;
    public static final int INSTRUCTION = 1;
    public static final int P1 = 2;
    public static final int P2 = 3;

    public ISOCommandAPDU(byte by, byte by2, byte by3, byte by4) {
        this(4, by, by2, by3, by4, null, -1);
    }

    public ISOCommandAPDU(int n, byte by, byte by2, byte by3, byte by4) {
        this(n, by, by2, by3, by4, null, -1);
    }

    public ISOCommandAPDU(byte by, byte by2, byte by3, byte by4, int n) {
        this(6, by, by2, by3, by4, null, n);
    }

    public ISOCommandAPDU(int n, byte by, byte by2, byte by3, byte by4, int n2) {
        this(n, by, by2, by3, by4, null, n2);
    }

    public ISOCommandAPDU(byte by, byte by2, byte by3, byte by4, byte[] byArray) {
        this(byArray.length + 5 + 4, by, by2, by3, by4, byArray, -1);
    }

    public ISOCommandAPDU(int n, byte by, byte by2, byte by3, byte by4, byte[] byArray) {
        this(n, by, by2, by3, by4, byArray, -1);
    }

    public ISOCommandAPDU(byte by, byte by2, byte by3, byte by4, byte[] byArray, int n) {
        this(byArray.length + 5 + 4, by, by2, by3, by4, byArray, n);
    }

    public ISOCommandAPDU(int n, byte by, byte by2, byte by3, byte by4, byte[] byArray, int n2) {
        super(n);
        this.le = n2;
        this.lc = byArray == null ? 0 : byArray.length;
        byte[] byArray2 = this.encode(byArray);
        int n3 = byArray2 == null ? 0 : byArray2.length;
        ((APDU)this).apdu_buffer[0] = by;
        ((APDU)this).apdu_buffer[1] = by2;
        ((APDU)this).apdu_buffer[2] = by3;
        ((APDU)this).apdu_buffer[3] = by4;
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, ((APDU)this).apdu_buffer, 4, n3);
        }
        ((APDU)this).apdu_length = 4 + n3;
    }

    public byte getCLA() {
        return ((APDU)this).apdu_buffer[0];
    }

    public byte getINS() {
        return ((APDU)this).apdu_buffer[1];
    }

    public byte getP1() {
        return ((APDU)this).apdu_buffer[2];
    }

    public byte getP2() {
        return ((APDU)this).apdu_buffer[3];
    }

    public int getLC() {
        return this.lc;
    }

    public int getLE() {
        return this.le;
    }

    public int getIsoCase() {
        boolean bl;
        boolean bl2 = bl = this.lc < 256 && this.le < 256;
        if (this.lc <= 0) {
            if (this.le < 0) {
                return 2;
            }
            if (bl) {
                return 8;
            }
            return 12;
        }
        if (this.le < 0) {
            if (bl) {
                return 32;
            }
            return 48;
        }
        if (bl) {
            return 128;
        }
        return 192;
    }

    public void append(byte[] byArray) throws IndexOutOfBoundsException {
        if (this.le != -1) {
            throw new IndexOutOfBoundsException("An le value exists in APDU buffer, therefore no append is possible");
        }
        super.append(byArray);
        this.lc += byArray.length;
    }

    public void append(byte by) throws IndexOutOfBoundsException {
        if (this.le != -1) {
            throw new IndexOutOfBoundsException("An le value exists in APDU buffer, therefore no append is possible");
        }
        super.append(by);
        ++this.lc;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("APDU_Buffer = ");
        stringBuffer.append(this.makeHex(this.getBytes()));
        stringBuffer.append(" (hex) | lc = ");
        stringBuffer.append(this.lc);
        stringBuffer.append(" | le = ");
        stringBuffer.append(this.le);
        return stringBuffer.toString();
    }

    private byte[] encode(byte[] byArray) {
        int n = byArray == null ? 0 : byArray.length;
        int n2 = 0;
        boolean bl = n < 256 && this.le < 256;
        n2 += n;
        if (n > 0) {
            int n3 = n2 = bl ? n2 + 1 : n2 + 3;
        }
        if (this.le >= 0) {
            int n4 = n2 = bl ? n2 + 1 : n2 + 2;
        }
        if (n2 == 0) {
            return null;
        }
        byte[] byArray2 = new byte[n2];
        int n5 = 0;
        if (n > 0) {
            if (bl) {
                byArray2[n5++] = (byte)(n & 0xFF);
            } else {
                byArray2[n5] = 0;
                byArray2[n5 + 1] = (byte)(n >> 8 & 0xFF);
                byArray2[n5 + 2] = (byte)(n & 0xFF);
                n5 += 3;
            }
            System.arraycopy(byArray, 0, byArray2, n5, n);
            n5 += n;
        }
        if (this.le >= 0) {
            if (bl) {
                byArray2[n5++] = (byte)(this.le & 0xFF);
            } else {
                byArray2[n5] = (byte)(this.le >> 8 & 0xFF);
                byArray2[n5 + 1] = (byte)(this.le & 0xFF);
            }
        }
        return byArray2;
    }

    private String makeHex(byte[] byArray) {
        int n = byArray.length;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        int n2 = 0;
        while (n2 < 2 * n) {
            byte by = n2 % 2 == 1 ? (byte)(byArray[n2 / 2] & 0xF) : (byte)(byArray[n2 / 2] >> 4 & 0xF);
            stringBuffer.append(String.valueOf((char)(by < 10 ? by + 48 : by + 55)) + (n2 % 2 == 1 ? string : ""));
            ++n2;
        }
        return stringBuffer.toString();
    }
}

