/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFile;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.iso.fs.CardRandomAccess;

public class CardRandomByteAccess
extends CardRandomAccess
implements DataOutput,
DataInput {
    public CardRandomByteAccess(CardFile cardFile) throws CardTerminalException, IOException {
        this(cardFile, "rw");
    }

    public CardRandomByteAccess(CardFile cardFile, String string) throws CardTerminalException, IOException {
        super(cardFile, string);
        if (!this.file.isTransparent()) {
            throw new CardIOException("not transparent: " + this.file.getPath());
        }
    }

    public int read() throws IOException, CardTerminalException {
        byte[] byArray = this.fileSystem.read(this.file.getPath(), this.filePointer, 1);
        ++this.filePointer;
        if (byArray == null) {
            return -1;
        }
        return byArray[0];
    }

    public int read(byte[] byArray) throws IOException, CardTerminalException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, CardTerminalException {
        byte[] byArray2 = this.fileSystem.read(this.file.getPath(), this.filePointer, n2);
        if (byArray2 == null) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        this.filePointer += byArray2.length;
        return byArray2.length;
    }

    public boolean readBoolean() throws IOException, CardTerminalException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException, CardTerminalException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public char readChar() throws IOException, CardTerminalException {
        byte[] byArray = new byte[2];
        this.read(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        return dataInputStream.readChar();
    }

    public double readDouble() throws IOException, CardTerminalException {
        byte[] byArray = new byte[8];
        this.read(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        return dataInputStream.readDouble();
    }

    public float readFloat() throws IOException, CardTerminalException {
        byte[] byArray = new byte[4];
        this.read(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        return dataInputStream.readFloat();
    }

    public void readFully(byte[] byArray) throws IOException, CardTerminalException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException, CardTerminalException {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = this.read(byArray, n + n4, n2 - n4);
            if (n3 < 0) {
                throw new EOFException();
            }
            n4 += n3;
        }
    }

    public int readInt() throws IOException, CardTerminalException {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        return dataInputStream.readInt();
    }

    public String readLine() throws IOException, CardTerminalException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) != -1 && n != 10) {
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public long readLong() throws IOException, CardTerminalException {
        byte[] byArray = new byte[8];
        this.readFully(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        return dataInputStream.readLong();
    }

    public short readShort() throws IOException, CardTerminalException {
        byte[] byArray = new byte[2];
        this.readFully(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        return dataInputStream.readShort();
    }

    public int readUnsignedByte() throws IOException, CardTerminalException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public int readUnsignedShort() throws IOException, CardTerminalException {
        byte[] byArray = new byte[2];
        this.readFully(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        return dataInputStream.readUnsignedShort();
    }

    public int skipBytes(int n) throws IOException, CardTerminalException {
        long l = this.file.getLength();
        if ((long)(this.filePointer + n) > l) {
            throw new EOFException("skip");
        }
        this.filePointer += n;
        return n;
    }

    public String readUTF() throws IOException, CardTerminalException {
        return DataInputStream.readUTF(this);
    }

    public void write(int n) throws IOException, CardTerminalException {
        byte[] byArray = new byte[]{(byte)n};
        this.fileSystem.write(this.file.getPath(), this.filePointer, byArray);
        ++this.filePointer;
    }

    public void write(byte[] byArray) throws IOException, CardTerminalException {
        this.fileSystem.write(this.file.getPath(), this.filePointer, byArray);
        this.filePointer += byArray.length;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException, CardTerminalException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.write(byArray2);
    }

    public void writeBoolean(boolean bl) throws IOException, CardTerminalException {
        this.write(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException, CardTerminalException {
        this.write(n);
    }

    public void writeBytes(String string) throws IOException, CardTerminalException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeBytes(string);
        this.write(byteArrayOutputStream.toByteArray());
    }

    public void writeChar(int n) throws IOException, CardTerminalException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeChar(n);
        this.write(byteArrayOutputStream.toByteArray());
    }

    public void writeChars(String string) throws IOException, CardTerminalException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeChars(string);
        this.write(byteArrayOutputStream.toByteArray());
    }

    public void writeDouble(double d) throws IOException, CardTerminalException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeDouble(d);
        this.write(byteArrayOutputStream.toByteArray());
    }

    public void writeFloat(float f) throws IOException, CardTerminalException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeFloat(f);
        this.write(byteArrayOutputStream.toByteArray());
    }

    public void writeInt(int n) throws IOException, CardTerminalException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(n);
        this.write(byteArrayOutputStream.toByteArray());
    }

    public void writeLong(long l) throws IOException, CardTerminalException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeLong(l);
        this.write(byteArrayOutputStream.toByteArray());
    }

    public void writeShort(int n) throws IOException, CardTerminalException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeShort(n);
        this.write(byteArrayOutputStream.toByteArray());
    }

    public void writeUTF(String string) throws IOException, CardTerminalException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF(string);
        this.write(byteArrayOutputStream.toByteArray());
    }

    protected void finalize() throws IOException {
        super.finalize();
    }
}

