/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.util.Enumeration;
import java.util.Vector;
import opencard.opt.iso.fs.CardFileAppID;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFilePartialAppID;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.CardFileShortFileID;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.security.SecurityDomain;

public class CardFilePath
implements SecurityDomain {
    public static final String SYM_SEPARATOR = "/";
    public static final String FID_SEPARATOR = ":";
    public static final String APPID_PREFIX = "#";
    public static final String PARTIALAPPID_POSTFIX = "*";
    public static final String ROOTFILEID = ":3F00";
    protected CardFilePathComponent[] components;
    private String string_representation;

    private static int separatorAt(String string, int n, int n2) {
        char[] cArray = new char[]{FID_SEPARATOR.charAt(0), SYM_SEPARATOR.charAt(0)};
        int n3 = 0;
        while (n3 < cArray.length) {
            char c = cArray[n3];
            if (string.charAt(n) == c) {
                if (n + 1 < n2 && string.charAt(n + 1) != c) {
                    return 1;
                }
                return 2;
            }
            ++n3;
        }
        return 0;
    }

    private CardFilePath() {
    }

    public CardFilePath(String string) throws CardIOException {
        if (string.length() == 0) {
            throw new CardIOException("empty path");
        }
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < string.length()) {
            switch (CardFilePath.separatorAt(string, n, string.length())) {
                case 1: {
                    vector.addElement(new Integer(n));
                    break;
                }
                case 2: {
                    ++n;
                }
            }
            ++n;
        }
        int n2 = vector.size() == 0 ? 1 : ((Integer)vector.elementAt(0) == 0 ? vector.size() : vector.size() + 1);
        this.components = new CardFilePathComponent[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < vector.size()) {
            block12: {
                String string2;
                int n6;
                block11: {
                    n6 = (Integer)vector.elementAt(n5);
                    string2 = null;
                    if (n6 != 0) break block11;
                    if (string.length() > 1) break block12;
                    n6 = 1;
                }
                string2 = string.substring(n3, n6);
                n3 = n6;
                this.components[n4] = CardFilePathComponent.createComponent(string2, n4, string, n2);
                ++n4;
            }
            ++n5;
        }
        if (n4 < n2) {
            String string3 = string.substring(n3);
            this.components[n4] = CardFilePathComponent.createComponent(string3, n4, string, n2);
        }
    }

    public CardFilePath(byte[] byArray) {
        this.components = new CardFilePathComponent[byArray.length / 2 + byArray.length % 2];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            this.components[n++] = n2 + 1 == byArray.length ? new CardFileShortFileID(byArray[n2]) : new CardFileFileID(byArray[n2], byArray[n2 + 1]);
            n2 += 2;
        }
    }

    public CardFilePath(CardFilePath cardFilePath) {
        this.components = new CardFilePathComponent[cardFilePath.components.length];
        int n = 0;
        while (n < this.components.length) {
            this.components[n] = cardFilePath.components[n];
            ++n;
        }
    }

    public Enumeration components() {
        return new 1();
    }

    public CardFilePath append(CardFilePath cardFilePath) {
        if (cardFilePath.components[0] instanceof CardFileAppID || cardFilePath.components[0] instanceof CardFilePartialAppID) {
            throw new CardIOException("attempt to append (partial) application ID " + cardFilePath);
        }
        if (this.components[this.components.length - 1] instanceof CardFileShortFileID) {
            throw new CardIOException("attempt to append after short file ID " + this);
        }
        CardFilePathComponent[] cardFilePathComponentArray = this.components;
        this.components = new CardFilePathComponent[cardFilePathComponentArray.length + cardFilePath.components.length];
        int n = 0;
        while (n < cardFilePathComponentArray.length) {
            this.components[n] = cardFilePathComponentArray[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < cardFilePath.components.length) {
            this.components[cardFilePathComponentArray.length + n2] = cardFilePath.components[n2];
            ++n2;
        }
        this.string_representation = null;
        return this;
    }

    public CardFilePath append(CardFilePathComponent cardFilePathComponent) {
        if (cardFilePathComponent instanceof CardFileAppID || cardFilePathComponent instanceof CardFilePartialAppID) {
            throw new CardIOException("attempt to append (partial) application ID " + cardFilePathComponent);
        }
        if (this.components[this.components.length - 1] instanceof CardFileShortFileID) {
            throw new CardIOException("attempt to append after short file ID " + this);
        }
        CardFilePathComponent[] cardFilePathComponentArray = this.components;
        this.components = new CardFilePathComponent[cardFilePathComponentArray.length + 1];
        int n = 0;
        while (n < cardFilePathComponentArray.length) {
            this.components[n] = cardFilePathComponentArray[n];
            ++n;
        }
        this.components[cardFilePathComponentArray.length] = cardFilePathComponent;
        this.string_representation = null;
        return this;
    }

    public boolean startsWith(CardFilePath cardFilePath) {
        if (cardFilePath.numberOfComponents() >= this.numberOfComponents()) {
            return false;
        }
        int n = 0;
        while (n < cardFilePath.numberOfComponents()) {
            if (!cardFilePath.components[n].equals(this.components[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CardFilePath)) {
            return false;
        }
        CardFilePath cardFilePath = (CardFilePath)object;
        if (this.numberOfComponents() != cardFilePath.numberOfComponents()) {
            return false;
        }
        int n = 0;
        while (n < cardFilePath.numberOfComponents()) {
            if (!cardFilePath.components[n].equals(this.components[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int commonPrefixLength(CardFilePath cardFilePath) {
        int n = this.components.length <= cardFilePath.components.length ? this.components.length : cardFilePath.components.length;
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            if (!this.components[n2].equals(cardFilePath.components[n2])) break;
            ++n2;
        }
        return n2;
    }

    public CardFilePath greatestCommonPrefix(CardFilePath cardFilePath) {
        int n = this.commonPrefixLength(cardFilePath);
        if (n == 0) {
            throw new IllegalArgumentException("no common prefix");
        }
        CardFilePath cardFilePath2 = new CardFilePath();
        cardFilePath2.components = new CardFilePathComponent[n + 1];
        int n2 = 0;
        while (n2 < cardFilePath2.components.length) {
            cardFilePath2.components[n2] = this.components[n2];
            ++n2;
        }
        return cardFilePath2;
    }

    public CardFilePath chompPrefix(CardFilePath cardFilePath) {
        if (!this.startsWith(cardFilePath)) {
            throw new IllegalArgumentException("illegal prefix " + cardFilePath + " for path " + this.toString());
        }
        CardFilePathComponent[] cardFilePathComponentArray = this.components;
        this.components = new CardFilePathComponent[cardFilePathComponentArray.length - cardFilePath.components.length];
        int n = 0;
        while (n < this.components.length) {
            this.components[n] = cardFilePathComponentArray[cardFilePath.components.length + n];
            ++n;
        }
        this.string_representation = null;
        return this;
    }

    public boolean chompTail() {
        if (this.components.length == 1) {
            return false;
        }
        CardFilePathComponent[] cardFilePathComponentArray = this.components;
        this.components = new CardFilePathComponent[cardFilePathComponentArray.length - 1];
        int n = 0;
        while (n < this.components.length) {
            this.components[n] = cardFilePathComponentArray[n];
            ++n;
        }
        this.string_representation = null;
        return true;
    }

    public CardFilePathComponent tail() {
        return this.components[this.components.length - 1];
    }

    public int numberOfComponents() {
        return this.components.length;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.string_representation == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.components.length) {
                stringBuffer.append(this.components[n].toString());
                ++n;
            }
            this.string_representation = stringBuffer.toString();
        }
        return this.string_representation;
    }

    private final class 1
    implements Enumeration {
        int idx;

        public boolean hasMoreElements() {
            return this.idx < CardFilePath.this.components.length;
        }

        public Object nextElement() {
            return CardFilePath.this.components[this.idx++];
        }

        /* synthetic */ 1() {
        }
    }
}

