/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.emv.mgmt;

import opencard.core.util.HexString;
import opencard.core.util.Tracer;
import opencard.opt.applet.AppletID;
import opencard.opt.applet.AppletInfo;
import opencard.opt.applet.mgmt.InvalidAppletInfoException;
import opencard.opt.emv.mgmt.EMVTags;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.util.TLV;

public class EMVAppletInfo
extends AppletInfo
implements EMVTags {
    private Tracer itracer = new Tracer((Object)this, class$opencard$opt$emv$mgmt$EMVAppletInfo != null ? class$opencard$opt$emv$mgmt$EMVAppletInfo : (class$opencard$opt$emv$mgmt$EMVAppletInfo = EMVAppletInfo.class$("opencard.opt.emv.mgmt.EMVAppletInfo")));
    protected byte[] prefName;
    protected byte[] prioInd;
    protected byte[] discrData;
    protected static final String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    static /* synthetic */ Class class$opencard$opt$emv$mgmt$EMVAppletInfo;

    protected EMVAppletInfo() {
        this.setDomain(new CardFilePath(":3F00"));
    }

    public EMVAppletInfo(AppletID appletID, String string) {
        this.setAppletID(appletID);
        this.setLabel(string);
    }

    public EMVAppletInfo(TLV tLV) throws InvalidAppletInfoException {
        this();
        this.fromEMVTLV(tLV);
    }

    public byte[] getPreferredName() {
        return this.prefName;
    }

    public byte[] getPriority() {
        return this.prioInd;
    }

    public byte[] getDiscretionaryData() {
        return this.discrData;
    }

    public void fromEMVTLV(TLV tLV) throws InvalidAppletInfoException {
        this.setAppletID(tLV);
        this.setLabel(tLV);
        this.setDomain(tLV);
        this.setPreferredName(tLV);
        this.setDiscretionaryData(tLV);
        this.setPriority(tLV);
    }

    private void setAppletID(TLV tLV) throws InvalidAppletInfoException {
        TLV tLV2 = tLV.findTag(EMVTags.TAG_EMV_ADF_NAME, null);
        if (tLV2 == null) {
            throw new InvalidAppletInfoException();
        }
        this.setAppletID(new AppletID(tLV2.valueAsByteArray()));
    }

    private void setLabel(TLV tLV) throws InvalidAppletInfoException {
        TLV tLV2 = tLV.findTag(EMVTags.TAG_EMV_APP_LABEL, null);
        if (tLV2 == null) {
            throw new InvalidAppletInfoException();
        }
        this.setLabel(new String(tLV2.valueAsByteArray()));
    }

    private void setPreferredName(TLV tLV) {
        TLV tLV2 = tLV.findTag(EMVTags.TAG_EMV_APP_PREF_NAME, null);
        this.prefName = tLV2 == null ? null : tLV2.valueAsByteArray();
    }

    private void setPriority(TLV tLV) {
        TLV tLV2 = tLV.findTag(EMVTags.TAG_EMV_APP_PRIO_IND, null);
        this.prioInd = tLV2 == null ? null : tLV2.valueAsByteArray();
    }

    private void setDiscretionaryData(TLV tLV) {
        TLV tLV2 = tLV.findTag(EMVTags.TAG_EMV_APP_DISCR_DATA, null);
        this.discrData = tLV2 == null ? null : tLV2.valueAsByteArray();
    }

    private void setDomain(TLV tLV) {
        CardFilePath cardFilePath = new CardFilePath("#" + EMVAppletInfo.hexify(this.getAppletID().getBytes(), false));
        this.setDomain(cardFilePath);
    }

    private static String hexify(byte[] byArray, boolean bl) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (bl && n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(hexChars[byArray[n2] >> 4 & 0xF]);
            stringBuffer.append(hexChars[byArray[n2] & 0xF]);
            if (++n == 16) {
                stringBuffer.append('\n');
                n = 0;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public TLV toEMVTLV() {
        TLV tLV;
        if (this.aid == null) {
            return null;
        }
        TLV tLV2 = null;
        TLV tLV3 = new TLV(EMVTags.TAG_EMV_ADF_NAME, this.getAppletID().getBytes());
        tLV2 = new TLV(EMVTags.TAG_EMV_APP_TEMPLATE, tLV3);
        if (this.label != null) {
            tLV = new TLV(EMVTags.TAG_EMV_APP_LABEL, this.getLabel().getBytes());
            tLV2.add(tLV);
        }
        if (this.prefName != null) {
            tLV = new TLV(EMVTags.TAG_EMV_APP_PREF_NAME, this.prefName);
            tLV2.add(tLV);
        }
        this.getDomain();
        if (this.discrData != null) {
            tLV = new TLV(EMVTags.TAG_EMV_APP_DISCR_DATA, this.discrData);
            tLV2.add(tLV);
        }
        if (this.prioInd != null) {
            tLV = new TLV(EMVTags.TAG_EMV_APP_PRIO_IND, this.prioInd);
            tLV2.add(tLV);
        }
        System.out.println("I have built an app TLV: " + tLV2.toString());
        return tLV2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("EMV AppletInfo:\n\t");
        stringBuffer.append(super.toString());
        if (this.prefName != null) {
            stringBuffer.append("Preferred Name: ").append(new String(this.prefName)).append("\n\t");
        }
        if (this.prioInd != null) {
            stringBuffer.append("Priority indicator: ").append(HexString.hexify((byte[])this.prioInd)).append("\n\t");
        }
        if (this.discrData != null) {
            stringBuffer.append("Discretionary data: ").append(this.discrData.toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

