/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.database;

import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.Tracer;
import opencard.opt.database.CommandNotAllowedException;
import opencard.opt.database.DataObject;
import opencard.opt.database.DatabaseCardService;
import opencard.opt.database.EndOfTableReachedException;
import opencard.opt.database.IncorrectParameterInDataFieldException;
import opencard.opt.database.InstructionCodeNotSupportedException;
import opencard.opt.database.MemoryFailureError;
import opencard.opt.database.ObjectAlreadyExistsException;
import opencard.opt.database.OperationNotSupportedException;
import opencard.opt.database.ReferencedObjectNotFoundException;
import opencard.opt.database.RequiredPrecedentCommandNotPerformedException;
import opencard.opt.database.SCQLError;
import opencard.opt.database.SCQLException;
import opencard.opt.database.SecurityAttribute;
import opencard.opt.database.SecurityStatusNotSatisfiedException;
import opencard.opt.database.WrongLengthException;
import opencard.opt.database.WrongLengthLeException;
import opencard.opt.database.WrongParameterException;

public class BasicDatabase
extends CardService
implements DatabaseCardService,
DatabaseCardService.Constants {
    private static Tracer ctracer = new Tracer(class$opencard$opt$database$BasicDatabase != null ? class$opencard$opt$database$BasicDatabase : (class$opencard$opt$database$BasicDatabase = BasicDatabase.class$("opencard.opt.database.BasicDatabase")));
    protected final int MAX_SIZE = 300;
    static /* synthetic */ Class class$opencard$opt$database$BasicDatabase;

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
    }

    public void createTable(String string, String string2, byte by, SecurityAttribute securityAttribute) throws SCQLException {
        string = string.toUpperCase();
        DataObject.isIdentifier(string);
        String[] stringArray = DataObject.parseString(string2.toUpperCase());
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-128));
        commandAPDU.append(DataObject.bodyAPDU(string));
        commandAPDU.append((byte)stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            commandAPDU.append(DataObject.bodyAPDU(stringArray[n].trim()));
            ++n;
        }
        if (by > 0) {
            commandAPDU.append((byte)1);
            commandAPDU.append(by);
        }
        if (securityAttribute != null) {
            commandAPDU.append(securityAttribute.getBytes());
        }
        this.sendAPDU(commandAPDU);
    }

    public void createTable(String string, String string2, SecurityAttribute securityAttribute) throws SCQLException {
        this.createTable(string, string2, (byte)0, securityAttribute);
    }

    public void createView(String string, String string2, String string3, String string4, SecurityAttribute securityAttribute) throws SCQLException {
        string = string.toUpperCase();
        DataObject.isIdentifier(string);
        string2 = string2.toUpperCase();
        DataObject.isIdentifier(string2);
        String[] stringArray = DataObject.parseString(string3.toUpperCase());
        String[] stringArray2 = DataObject.parseString(string4);
        String[] stringArray3 = new String[stringArray2.length];
        String[] stringArray4 = new String[stringArray2.length];
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = 0;
            while (!DataObject.isOperator(stringArray2[n].charAt(n2))) {
                ++n2;
            }
            stringArray3[n] = stringArray2[n].substring(0, n2).toUpperCase().trim();
            stringArray2[n] = stringArray2[n].substring(n2, stringArray2[n].length()).trim();
            n2 = DataObject.isOperator(stringArray2[n].charAt(1)) ? 2 : 1;
            stringArray4[n] = stringArray2[n].substring(0, n2).trim();
            stringArray2[n] = stringArray2[n].substring(n2, stringArray2[n].length()).trim();
            ++n;
        }
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-127));
        commandAPDU.append(DataObject.bodyAPDU(string));
        commandAPDU.append(DataObject.bodyAPDU(string2));
        if (stringArray[0].trim().equals("*")) {
            commandAPDU.append((byte)0);
        } else {
            commandAPDU.append((byte)stringArray.length);
            n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringArray[n].trim();
                DataObject.isIdentifier(stringArray[n]);
                commandAPDU.append(DataObject.bodyAPDU(stringArray[n]));
                ++n;
            }
        }
        if (stringArray3.length > 0) {
            commandAPDU.append((byte)stringArray3.length);
            n = 0;
            while (n < stringArray3.length) {
                commandAPDU.append(DataObject.bodyAPDU(stringArray3[n].trim()));
                commandAPDU.append((byte)1);
                commandAPDU.append(DataObject.operator(stringArray4[n].trim()));
                commandAPDU.append(DataObject.bodyAPDU(stringArray2[n]));
                ++n;
            }
        } else {
            commandAPDU.append((byte)0);
        }
        if (securityAttribute != null) {
            commandAPDU.append(securityAttribute.getBytes());
        }
        this.sendAPDU(commandAPDU);
    }

    public void createDictionary(String string) throws SCQLException {
        DataObject.isDictionaryIdentifier(string);
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-126));
        commandAPDU.append(DataObject.bodyAPDU(string));
        this.sendAPDU(commandAPDU);
    }

    public void dropTable(String string) throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-125));
        commandAPDU.append(DataObject.bodyAPDU(string.toUpperCase()));
        this.sendAPDU(commandAPDU);
    }

    public void dropView(String string) throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-124));
        commandAPDU.append(DataObject.bodyAPDU(string.toUpperCase()));
        this.sendAPDU(commandAPDU);
    }

    public void grant(String string, String string2, String string3) throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-123));
        commandAPDU.append((byte)1);
        commandAPDU.append(DataObject.parsePrivilege(string));
        commandAPDU.append(DataObject.bodyAPDU(string2.toUpperCase()));
        commandAPDU.append(DataObject.bodyAPDU(string3.toUpperCase()));
        this.sendAPDU(commandAPDU);
    }

    public void revoke(String string, String string2, String string3) throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-122));
        commandAPDU.append((byte)1);
        commandAPDU.append(DataObject.parsePrivilege(string));
        commandAPDU.append(DataObject.bodyAPDU(string2.toUpperCase()));
        commandAPDU.append(DataObject.bodyAPDU(string3.toUpperCase()));
        this.sendAPDU(commandAPDU);
    }

    public void declareCursor(String string, String string2, String string3) throws SCQLException {
        String[] stringArray = DataObject.parseString(string2.toUpperCase());
        String[] stringArray2 = DataObject.parseString(string3);
        String[] stringArray3 = new String[stringArray2.length];
        String[] stringArray4 = new String[stringArray2.length];
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = 0;
            while (!DataObject.isOperator(stringArray2[n].charAt(n2))) {
                ++n2;
            }
            stringArray3[n] = stringArray2[n].substring(0, n2).toUpperCase();
            stringArray2[n] = stringArray2[n].substring(n2, stringArray2[n].length());
            n2 = DataObject.isOperator(stringArray2[n].charAt(1)) ? 2 : 1;
            stringArray4[n] = stringArray2[n].substring(0, n2);
            stringArray2[n] = stringArray2[n].substring(n2, stringArray2[n].length());
            ++n;
        }
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-121));
        commandAPDU.append(DataObject.bodyAPDU(string.toUpperCase().trim()));
        if (stringArray[0].trim().equals("*")) {
            commandAPDU.append((byte)0);
        } else {
            commandAPDU.append((byte)stringArray.length);
            n = 0;
            while (n < stringArray.length) {
                DataObject.isIdentifier(stringArray[n].trim());
                commandAPDU.append(DataObject.bodyAPDU(stringArray[n].trim()));
                ++n;
            }
        }
        if (stringArray3.length > 0) {
            commandAPDU.append((byte)stringArray3.length);
            n = 0;
            while (n < stringArray2.length) {
                commandAPDU.append(DataObject.bodyAPDU(stringArray3[n].trim()));
                commandAPDU.append((byte)1);
                commandAPDU.append(DataObject.operator(stringArray4[n].trim()));
                commandAPDU.append(DataObject.bodyAPDU(stringArray2[n].trim()));
                ++n;
            }
        } else {
            commandAPDU.append((byte)0);
        }
        this.sendAPDU(commandAPDU);
    }

    public void open() throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-120, (byte)0));
        this.sendAPDU(commandAPDU);
    }

    public void next() throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-119, (byte)0));
        this.sendAPDU(commandAPDU);
    }

    public String[] fetch(byte by) throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-118, (byte)0));
        if (by == 0) {
            try {
                this.sendAPDU(commandAPDU);
            }
            catch (WrongLengthLeException wrongLengthLeException) {
                commandAPDU.append(wrongLengthLeException.getRightLength());
            }
        } else {
            commandAPDU.append(by);
        }
        return DataObject.responseToString(this.sendAPDU(commandAPDU));
    }

    public String[] fetch() throws SCQLException {
        return this.fetch((byte)0);
    }

    public String[] fetchNext(byte by) throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-117, (byte)0));
        if (by == 0) {
            try {
                this.sendAPDU(commandAPDU);
            }
            catch (WrongLengthLeException wrongLengthLeException) {
                commandAPDU.append(wrongLengthLeException.getRightLength());
            }
        } else {
            commandAPDU.append(by);
        }
        return DataObject.responseToString(this.sendAPDU(commandAPDU));
    }

    public String[] fetchNext() throws SCQLException {
        return this.fetchNext((byte)0);
    }

    public void insert(String string, String string2) throws SCQLException {
        String[] stringArray = DataObject.parseString(string2);
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-116));
        commandAPDU.append(DataObject.bodyAPDU(string.toUpperCase()));
        commandAPDU.append((byte)stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            commandAPDU.append(DataObject.bodyAPDU(stringArray[n]));
            ++n;
        }
        this.sendAPDU(commandAPDU);
    }

    public void update(String string) throws SCQLException {
        String[] stringArray = DataObject.parseString(string);
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (stringArray[n].charAt(n2) != '=') {
                ++n2;
            }
            stringArray2[n] = stringArray[n].substring(n2 + 1, stringArray[n].length());
            stringArray[n] = stringArray[n].substring(0, n2);
            ++n;
        }
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-115));
        commandAPDU.append((byte)stringArray.length);
        n = 0;
        while (n < stringArray.length) {
            commandAPDU.append(DataObject.bodyAPDU(stringArray[n].toUpperCase().trim()));
            commandAPDU.append(DataObject.bodyAPDU(stringArray2[n]));
            ++n;
        }
        this.sendAPDU(commandAPDU);
    }

    public void delete() throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-114, (byte)0));
        this.sendAPDU(commandAPDU);
    }

    public void begin() throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)18, (byte)0, (byte)-128, (byte)0));
        this.sendAPDU(commandAPDU);
    }

    public void commit() throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)18, (byte)0, (byte)-127, (byte)0));
        this.sendAPDU(commandAPDU);
    }

    public void rollback() throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)18, (byte)0, (byte)-126, (byte)0));
        this.sendAPDU(commandAPDU);
    }

    public void presentUser(String string, SecurityAttribute securityAttribute) throws SCQLException {
        string = string.toUpperCase();
        DataObject.isIdentifier(string);
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)20, (byte)0, (byte)-128));
        if (securityAttribute == null) {
            commandAPDU.append(DataObject.bodyAPDU(string));
        } else {
            int n = string.length() + securityAttribute.getDataLength() + 4;
            commandAPDU.append((byte)127);
            commandAPDU.append((byte)33);
            commandAPDU.append((byte)n);
            commandAPDU.append((byte)95);
            commandAPDU.append((byte)32);
            commandAPDU.append(DataObject.bodyAPDU(string));
            commandAPDU.append(securityAttribute.getBytes());
        }
        this.sendAPDU(commandAPDU);
    }

    public void presentUser(String string) throws SCQLException {
        this.presentUser(string, null);
    }

    public void createUser(String string, String string2, SecurityAttribute securityAttribute) throws SCQLException {
        string.toUpperCase();
        DataObject.isIdentifier(string);
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)20, (byte)0, (byte)-127));
        commandAPDU.append(DataObject.bodyAPDU(string));
        if (!string2.equals("DBOO") && !string2.equals("DBBU")) {
            throw new WrongParameterException(string2);
        }
        commandAPDU.append(DataObject.bodyAPDU(string2));
        if (securityAttribute != null) {
            commandAPDU.append(securityAttribute.getBytes());
        }
        this.sendAPDU(commandAPDU);
    }

    public void deleteUser(String string) throws SCQLException {
        CommandAPDU commandAPDU = new CommandAPDU(300);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)20, (byte)0, (byte)-126));
        commandAPDU.append(DataObject.bodyAPDU(string.toUpperCase()));
        this.sendAPDU(commandAPDU);
    }

    protected void throwException(ResponseAPDU responseAPDU) throws SCQLException {
        byte by = responseAPDU.sw1();
        byte by2 = responseAPDU.sw2();
        switch (by) {
            case 108: {
                throw new WrongLengthLeException(by2);
            }
            case -112: {
                switch (by2) {
                    default: {
                        throw new SCQLException("Unknown error code : " + (by & 0xFF) + " " + (by2 & 0xFF));
                    }
                    case 0: {
                        return;
                    }
                }
            }
            case 98: {
                switch (by2) {
                    case -126: {
                        throw new EndOfTableReachedException();
                    }
                }
                throw new SCQLException("Unknown error code : " + (by & 0xFF) + " " + (by2 & 0xFF));
            }
            case 101: {
                switch (by2) {
                    case 0: {
                        throw new SCQLError();
                    }
                    case 98: {
                        throw new MemoryFailureError();
                    }
                }
                throw new SCQLException("Unknown error code : " + (by & 0xFF) + " " + (by2 & 0xFF));
            }
            case 103: {
                switch (by2) {
                    case 0: {
                        throw new WrongLengthException();
                    }
                }
                throw new SCQLException("Unknown error code : " + (by & 0xFF) + " " + (by2 & 0xFF));
            }
            case 105: {
                switch (by2) {
                    case 0: {
                        throw new CommandNotAllowedException();
                    }
                    case -126: {
                        throw new SecurityStatusNotSatisfiedException();
                    }
                    case -123: {
                        throw new RequiredPrecedentCommandNotPerformedException();
                    }
                }
                throw new SCQLException("Unknown error code : " + (by & 0xFF) + " " + (by2 & 0xFF));
            }
            case 106: {
                switch (by2) {
                    case -128: {
                        throw new WrongParameterException();
                    }
                    case -127: {
                        throw new IncorrectParameterInDataFieldException();
                    }
                    case -124: {
                        throw new OperationNotSupportedException();
                    }
                    case -120: {
                        throw new ReferencedObjectNotFoundException();
                    }
                    case -119: {
                        throw new ObjectAlreadyExistsException();
                    }
                }
                throw new SCQLException("Unknown error code : " + (by & 0xFF) + " " + (by2 & 0xFF));
            }
            case 109: {
                switch (by2) {
                    case 0: {
                        throw new InstructionCodeNotSupportedException();
                    }
                }
                throw new SCQLException("Unknown error code : " + (by & 0xFF) + " " + (by2 & 0xFF));
            }
            default: {
                throw new SCQLException("Unknown error code : " + (by & 0xFF) + " " + (by2 & 0xFF));
            }
            case 97: {
                return;
            }
        }
    }

    protected ResponseAPDU sendAPDU(CommandAPDU commandAPDU) throws SCQLException {
        ResponseAPDU responseAPDU = null;
        try {
            this.allocateCardChannel();
            if (commandAPDU.getLength() > 5) {
                commandAPDU.setByte(4, commandAPDU.getLength() - 5 - commandAPDU.getByte(4));
            }
            ctracer.debug("sendAPDU", "-> CommandAPDU : " + commandAPDU.toString());
            responseAPDU = this.getCardChannel().sendCommandAPDU(commandAPDU);
            ctracer.debug("sendAPDU", "<- ResponseAPDU : " + responseAPDU.toString());
            this.releaseCardChannel();
            this.throwException(responseAPDU);
        }
        catch (CardTerminalException cardTerminalException) {
            cardTerminalException.printStackTrace();
        }
        return responseAPDU;
    }

    public static boolean knows(CardID cardID, CardServiceScheduler cardServiceScheduler) {
        boolean bl = false;
        CommandAPDU commandAPDU = null;
        ResponseAPDU responseAPDU = null;
        commandAPDU = new CommandAPDU(13);
        commandAPDU.append(DataObject.headerAPDU((byte)0, (byte)20, (byte)0, (byte)-128, (byte)8));
        commandAPDU.append(DataObject.bodyAPDU("PUBLIC"));
        commandAPDU.append((byte)0);
        try {
            ctracer.debug("knows", "PRESENT USER CommandAPDU : " + commandAPDU.toString());
            responseAPDU = cardServiceScheduler.getSlotChannel().sendAPDU(commandAPDU);
            ctracer.debug("knows", "PRESENT USER ResponseAPDU : " + responseAPDU.toString());
        }
        catch (Exception exception) {
            System.err.println("Communication Problems During PresentUser.");
        }
        if (responseAPDU.sw1() == -112 && responseAPDU.sw2() == 0) {
            bl = true;
            ctracer.info("knows", "DATABASE_CARDTYPE card found!");
        } else {
            bl = false;
            ctracer.info("knows", "Not a DATABASE card.");
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

