/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class SystemAccess {
    private static SystemAccess _theSystem = new SystemAccess();
    private static Hashtable _registeredSystems = new Hashtable();

    public boolean getBoolean(String string) {
        return Boolean.getBoolean(string);
    }

    public Properties getProperties() {
        return System.getProperties();
    }

    public String getProperty(String string) {
        return System.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return System.getProperty(string, string2);
    }

    public static SystemAccess getSystemAccess() {
        SystemAccess systemAccess = (SystemAccess)_registeredSystems.get(Thread.currentThread());
        if (systemAccess == null) {
            return _theSystem;
        }
        return systemAccess;
    }

    public void loadLibrary(String string) {
        System.loadLibrary(string);
    }

    public Properties loadProperties(String string) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(new File(string)));
        return properties;
    }

    public static void setSystemAccess(SystemAccess systemAccess) {
        _registeredSystems.put(Thread.currentThread(), systemAccess);
    }
}

