/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.Slot;
import opencard.core.util.Tracer;

public final class SlotChannel {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$terminal$SlotChannel != null ? class$opencard$core$terminal$SlotChannel : (class$opencard$core$terminal$SlotChannel = SlotChannel.class$("opencard.core.terminal.SlotChannel")));
    private final CardTerminal terminal;
    private final int slotID;
    private boolean slotChannelState = false;
    private Object scheduler;
    private Object lockHandle;
    static /* synthetic */ Class class$opencard$core$terminal$SlotChannel;

    public SlotChannel(CardTerminal cardTerminal, int n, Object object) {
        this.terminal = cardTerminal;
        this.slotID = n;
        this.slotChannelState = true;
        this.lockHandle = object;
    }

    public Object getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Object object) {
        this.scheduler = object;
    }

    public ResponseAPDU sendAPDU(CommandAPDU commandAPDU) throws CardTerminalException {
        return this.terminal.sendAPDU(this, commandAPDU);
    }

    public ResponseAPDU sendAPDU(CommandAPDU commandAPDU, int n) throws CardTerminalException {
        return this.terminal.sendAPDU(this, commandAPDU);
    }

    public Slot getSlot() {
        return this.terminal.getSlot(this.slotID);
    }

    public int getSlotNumber() {
        return this.slotID;
    }

    public CardTerminal getCardTerminal() {
        return this.terminal;
    }

    public Object getLockHandle() {
        return this.lockHandle;
    }

    public CardID reset(int n) throws CardTerminalException {
        return this.terminal.reset(this);
    }

    public CardID reset() throws CardTerminalException {
        return this.terminal.reset(this);
    }

    public boolean isOpen() {
        return this.slotChannelState;
    }

    public void close() throws CardTerminalException {
        this.itracer.debug("close", "closing channel");
        this.slotChannelState = false;
        this.terminal.closeSlotChannel(this);
    }

    public CardID getCardID() throws CardTerminalException {
        return this.terminal.getCardID(this.slotID);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n+ state ").append(this.slotChannelState ? " open" : " closed");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

