/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import opencard.core.event.CTListener;
import opencard.core.event.EventGenerator;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.Observer;
import opencard.core.terminal.Pollable;
import opencard.core.util.Tracer;

public final class CardTerminalRegistry {
    private Observer observer;
    protected Hashtable ctListeners = new Hashtable();
    private static Tracer ctracer = new Tracer(class$opencard$core$terminal$CardTerminalRegistry != null ? class$opencard$core$terminal$CardTerminalRegistry : (class$opencard$core$terminal$CardTerminalRegistry = CardTerminalRegistry.class$("opencard.core.terminal.CardTerminalRegistry")));
    private static final CardTerminalRegistry registry = new CardTerminalRegistry();
    private Vector registeredTerminals = new Vector();
    static /* synthetic */ Class class$opencard$core$terminal$CardTerminalRegistry;

    public void setObserver(Observer observer) {
        this.observer = observer;
    }

    private CardTerminalRegistry() {
    }

    public static synchronized CardTerminalRegistry getRegistry() {
        return registry;
    }

    public void add(CardTerminal cardTerminal) throws CardTerminalException {
        this.registeredTerminals.addElement(cardTerminal);
        cardTerminal.open();
    }

    public void addPollable(Pollable pollable) {
        if (this.observer != null) {
            this.observer.updateTerminals(pollable, true);
        }
    }

    public CardTerminal cardTerminalForName(String string) {
        CardTerminal cardTerminal = null;
        Vector vector = this.registeredTerminals;
        synchronized (vector) {
            int n = 0;
            while (n < this.countCardTerminals()) {
                if (((CardTerminal)this.registeredTerminals.elementAt(n)).getName().equals(string)) {
                    cardTerminal = (CardTerminal)this.registeredTerminals.elementAt(n);
                    break;
                }
                ++n;
            }
        }
        return cardTerminal;
    }

    public int countCardTerminals() {
        return this.registeredTerminals.size();
    }

    public Enumeration getCardTerminals() {
        return ((Vector)this.registeredTerminals.clone()).elements();
    }

    public boolean remove(String string) throws CardTerminalException {
        CardTerminal cardTerminal = null;
        Vector vector = this.registeredTerminals;
        synchronized (vector) {
            int n = 0;
            while (n < this.registeredTerminals.size()) {
                cardTerminal = (CardTerminal)this.registeredTerminals.elementAt(n);
                if (cardTerminal.getName().equals(string)) {
                    cardTerminal.close();
                    this.registeredTerminals.removeElementAt(n);
                    break;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean remove(CardTerminal cardTerminal) throws CardTerminalException {
        ctracer.debug("remove", "closing " + cardTerminal);
        cardTerminal.close();
        ctracer.debug("remove", "removing " + cardTerminal);
        boolean bl = this.registeredTerminals.removeElement(cardTerminal);
        ctracer.debug("remove", "status " + bl);
        return bl;
    }

    public boolean removePollable(Pollable pollable) {
        if (this.observer != null) {
            return this.observer.updateTerminals(pollable, false);
        }
        return false;
    }

    protected void cardInserted(CardTerminal cardTerminal, int n) {
        if (this.observer != null) {
            this.observer.updateCards(cardTerminal, n, true);
        }
    }

    protected void cardRemoved(CardTerminal cardTerminal, int n) {
        if (this.observer != null) {
            this.observer.updateCards(cardTerminal, n, false);
        }
    }

    public void setPollInterval(int n) {
        EventGenerator.getGenerator().setPollInterval(n);
    }

    public void addCTListener(CTListener cTListener) {
        EventGenerator.getGenerator().addCTListener(cTListener);
    }

    public void createEventsForPresentCards(CTListener cTListener) throws CardTerminalException {
        EventGenerator.getGenerator().createEventsForPresentCards(cTListener);
    }

    public int getPollInterval() {
        return EventGenerator.getGenerator().getPollInterval();
    }

    public void removeCTListener(CTListener cTListener) {
        EventGenerator.getGenerator().removeCTListener(cTListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

