/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.service.CHVDialog;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

public abstract class CardService {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$service$CardService != null ? class$opencard$core$service$CardService : (class$opencard$core$service$CardService = CardService.class$("opencard.core.service.CardService")));
    private static Tracer ctracer = new Tracer(class$opencard$core$service$CardService != null ? class$opencard$core$service$CardService : (class$opencard$core$service$CardService = CardService.class$("opencard.core.service.CardService")));
    private SmartCard smart_card;
    private CardServiceScheduler cs_scheduler;
    private CardChannel card_channel;
    private CardType type;
    private boolean is_provided = false;
    private boolean is_blocking = false;
    private CHVDialog chv_dialog;
    static /* synthetic */ Class class$opencard$core$service$CardService;

    protected CardService() {
        ctracer.debug("<init>", "default constructor of " + this);
    }

    public void setCardChannel(CardChannel cardChannel) {
        this.card_channel = cardChannel;
        this.is_provided = cardChannel != null;
    }

    public final CardChannel getCardChannel() {
        return this.card_channel;
    }

    public void setCHVDialog(CHVDialog cHVDialog) {
        this.chv_dialog = cHVDialog;
    }

    public final CHVDialog getCHVDialog() {
        return this.chv_dialog;
    }

    public final SmartCard getCard() {
        return this.smart_card;
    }

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        this.itracer.debug("initialize", "(" + cardServiceScheduler + "," + smartCard + ")");
        this.smart_card = smartCard;
        this.cs_scheduler = cardServiceScheduler;
        this.is_blocking = bl;
        this.type = this.type;
    }

    protected void allocateCardChannel() throws InvalidCardChannelException {
        this.assertSchedulerStillAlive();
        if (!this.is_provided) {
            this.itracer.debug("allocateCardChannel", "allocating");
            try {
                this.card_channel = this.cs_scheduler.allocateCardChannel(this, this.is_blocking);
                if (this.card_channel == null) {
                    throw new InvalidCardChannelException("channel in use");
                }
            }
            catch (CardTerminalException cardTerminalException) {
                throw new InvalidCardChannelException(cardTerminalException.toString());
            }
        }
    }

    protected void releaseCardChannel() throws InvalidCardChannelException {
        this.assertSchedulerStillAlive();
        if (!this.is_provided) {
            this.itracer.debug("releaseCardChannel", "releasing");
            this.cs_scheduler.releaseCardChannel(this.card_channel);
            this.card_channel = null;
        }
    }

    private void assertSchedulerStillAlive() throws InvalidCardChannelException {
        boolean bl = false;
        try {
            bl = this.cs_scheduler.isAlive();
        }
        catch (CardTerminalException cardTerminalException) {
            throw new InvalidCardChannelException(cardTerminalException.toString());
        }
        if (!bl) {
            this.card_channel = null;
            this.cs_scheduler = null;
            throw new InvalidCardChannelException("card removed?");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

