/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.event;

import java.util.Enumeration;
import java.util.Vector;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Observer;
import opencard.core.terminal.Pollable;
import opencard.core.util.Tracer;

public final class EventGenerator
implements Observer,
Runnable {
    private static Tracer ctracer = new Tracer(class$opencard$core$event$EventGenerator != null ? class$opencard$core$event$EventGenerator : (class$opencard$core$event$EventGenerator = EventGenerator.class$("opencard.core.event.EventGenerator")));
    private Vector listeners = new Vector();
    private static EventGenerator theGenerator = null;
    private Thread t;
    private static int pollInterval = 500;
    private Vector pollables = new Vector();
    static /* synthetic */ Class class$opencard$core$event$EventGenerator;

    public static EventGenerator getGenerator() {
        if (theGenerator == null) {
            theGenerator = new EventGenerator();
            CardTerminalRegistry.getRegistry().setObserver(theGenerator);
        }
        return theGenerator;
    }

    public void addCTListener(CTListener cTListener) {
        this.listeners.addElement(cTListener);
    }

    public void createEventsForPresentCards(CTListener cTListener) throws CardTerminalException {
        Enumeration enumeration = CardTerminalRegistry.getRegistry().getCardTerminals();
        while (enumeration.hasMoreElements()) {
            CardTerminal cardTerminal = (CardTerminal)enumeration.nextElement();
            int n = cardTerminal.getSlots();
            int n2 = 0;
            while (n2 < n) {
                if (cardTerminal.isCardPresent(n2)) {
                    cTListener.cardInserted(new CardTerminalEvent(cardTerminal, 1, n2));
                }
                ++n2;
            }
        }
    }

    public void removeCTListener(CTListener cTListener) {
        this.listeners.removeElement(cTListener);
    }

    public void setPollInterval(int n) {
        pollInterval = n;
    }

    public int getPollInterval() {
        return pollInterval;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (true) {
            try {
                block9: while (true) {
                    Thread.sleep(pollInterval);
                    Vector vector = this.pollables;
                    // MONITORENTER : vector
                    Enumeration enumeration = this.pollables.elements();
                    while (true) {
                        if (!enumeration.hasMoreElements()) {
                            // MONITOREXIT : vector
                            continue block9;
                        }
                        Pollable pollable = (Pollable)enumeration.nextElement();
                        try {
                            pollable.poll();
                        }
                        catch (RuntimeException runtimeException) {
                            ctracer.debug("run", runtimeException);
                        }
                        catch (CardTerminalException cardTerminalException) {
                            ctracer.debug("run", cardTerminalException);
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : vector
                    throw throwable;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void updateCards(CardTerminal cardTerminal, int n, boolean bl) {
        ctracer.debug("updateCards", "card " + (bl ? "inserted" : "removed") + " slotID = " + n);
        if (!this.listeners.isEmpty()) {
            CTListener cTListener = null;
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                cTListener = (CTListener)enumeration.nextElement();
                try {
                    if (bl) {
                        cTListener.cardInserted(new CardTerminalEvent(cardTerminal, 1, n));
                        continue;
                    }
                    cTListener.cardRemoved(new CardTerminalEvent(cardTerminal, 2, n));
                }
                catch (RuntimeException runtimeException) {
                    ctracer.critical("updateCards", runtimeException);
                }
                catch (CardTerminalException cardTerminalException) {
                    ctracer.critical("updateCards", cardTerminalException);
                }
            }
            ctracer.debug("updateCards", "notified CTListeners");
        }
    }

    public boolean updateTerminals(Pollable pollable, boolean bl) {
        Vector vector = this.pollables;
        synchronized (vector) {
            if (bl) {
                ctracer.debug("updateTerminals", "new pollable Terminal = " + pollable);
                this.pollables.addElement(pollable);
                try {
                    pollable.poll();
                }
                catch (RuntimeException runtimeException) {
                    ctracer.debug("run", runtimeException);
                }
                catch (CardTerminalException cardTerminalException) {
                    ctracer.debug("run", cardTerminalException);
                }
                if (this.t == null) {
                    this.t = new Thread(this);
                    this.t.setDaemon(true);
                    this.t.start();
                }
                boolean bl2 = true;
                Object var5_8 = null;
                return bl2;
            }
            ctracer.debug("updateTerminals", "remove pollable Terminal = " + pollable);
            boolean bl3 = this.pollables.removeElement(pollable);
            Object var5_9 = null;
            return bl3;
        }
    }

    private EventGenerator() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

