/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.spi.AbstractRegistryEntry;
import org.apache.batik.ext.awt.image.spi.URLRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class JDKRegistryEntry
extends AbstractRegistryEntry
implements URLRegistryEntry {
    public static final float PRIORITY = 1000000.0f;
    static Component mediaComponent;
    static MediaTracker mediaTracker;
    static int id;

    public JDKRegistryEntry() {
        super("JDK", 1000000.0f, new String[0], new String[]{"image/gif"});
    }

    public boolean isCompatibleURL(ParsedURL purl) {
        try {
            URL url = new URL(purl.toString());
        }
        catch (MalformedURLException mue) {
            return false;
        }
        return true;
    }

    public Filter handleURL(ParsedURL purl, boolean needRawData) {
        URL url;
        try {
            url = new URL(purl.toString());
        }
        catch (MalformedURLException mue) {
            return null;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image img = tk.createImage(url);
        if (img == null) {
            return null;
        }
        RenderedImage ri = this.loadImage(img);
        if (ri == null) {
            return null;
        }
        return new RedRable(GraphicsUtil.wrap(ri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage loadImage(Image img) {
        int myID;
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        MediaTracker mediaTracker = JDKRegistryEntry.mediaTracker;
        synchronized (mediaTracker) {
            myID = id++;
        }
        JDKRegistryEntry.mediaTracker.addImage(img, myID);
        while (true) {
            try {
                JDKRegistryEntry.mediaTracker.waitForID(myID);
            }
            catch (InterruptedException ie) {
                continue;
            }
            break;
        }
        JDKRegistryEntry.mediaTracker.removeImage(img, myID);
        if (img.getWidth(null) == -1 || img.getHeight(null) == -1) {
            return null;
        }
        BufferedImage bi = null;
        bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(img, 0, 0, null);
        g2d.dispose();
        return bi;
    }

    static {
        PRIORITY = 1000000.0f;
        mediaComponent = new Label();
        mediaTracker = new MediaTracker(mediaComponent);
        id = 0;
    }
}

