/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import sos.koa.CandidateList;
import sos.koa.ClearAdapter;
import sos.koa.CountAdapter;
import sos.koa.DecryptAdapter;
import sos.koa.ExitAdapter;
import sos.koa.HelpAdapter;
import sos.koa.ImportCandidatesAdapter;
import sos.koa.ImportKeyAdapter;
import sos.koa.ImportVotesAdapter;
import sos.koa.KOAConstants;
import sos.koa.ReportAdapter;
import sos.koa.RestartAdapter;
import sos.koa.VoteSet;

public class MenuPanel
extends JPanel
implements KOAConstants {
    private static MenuPanel theInstance = new MenuPanel();
    int state;
    JButton restartButton;
    JButton clearButton;
    JButton importCandidatesButton;
    JButton importVotesButton;
    JButton importPrivateKeyButton;
    JButton importPublicKeyButton;
    JButton decryptButton;
    JButton countButton;
    JButton reportButton;
    JButton helpButton;
    JButton exitButton;
    ArrayList rawVotes;
    VoteSet voteSet;
    CandidateList candidates = null;
    PrivateKey privateKey;
    PublicKey publicKey;
    File currentDir = new File(".");
    HelpAdapter helpAdapter;

    private MenuPanel() {
        this.restartButton = new JButton("Opnieuw Beginnen");
        this.clearButton = new JButton("Wissen Gegevens");
        this.importCandidatesButton = new JButton("Importeren Kandidatenbestand");
        this.importVotesButton = new JButton("Importeren Export Stembus");
        this.importPrivateKeyButton = new JButton("Importeren Private Sleutel");
        this.importPublicKeyButton = new JButton("Importeren Publieke Sleutel");
        this.decryptButton = new JButton("Ontsleutelen");
        this.countButton = new JButton("Tellen");
        this.reportButton = new JButton("Rapporteren");
        this.helpButton = new JButton("Help");
        this.exitButton = new JButton("Sluiten");
        JPanel panel = new JPanel(new GridLayout(10, 1));
        panel.add(this.restartButton);
        panel.add(this.clearButton);
        panel.add(this.importCandidatesButton);
        panel.add(this.importVotesButton);
        panel.add(this.importPrivateKeyButton);
        panel.add(this.importPublicKeyButton);
        panel.add(this.decryptButton);
        panel.add(this.countButton);
        panel.add(this.reportButton);
        panel.add(this.exitButton);
        this.add((Component)panel, "Center");
        this.helpAdapter = new HelpAdapter();
        this.helpButton.addActionListener(this.helpAdapter);
        this.add(this.helpButton);
        this.setState(0);
        this.restartButton.addActionListener(new RestartAdapter());
        this.clearButton.addActionListener(new ClearAdapter());
        this.importCandidatesButton.addActionListener(new ImportCandidatesAdapter());
        this.importVotesButton.addActionListener(new ImportVotesAdapter());
        this.importPrivateKeyButton.addActionListener(new ImportKeyAdapter(1));
        this.importPublicKeyButton.addActionListener(new ImportKeyAdapter(0));
        this.decryptButton.addActionListener(new DecryptAdapter());
        this.countButton.addActionListener(new CountAdapter());
        this.reportButton.addActionListener(new ReportAdapter());
        this.exitButton.addActionListener(new ExitAdapter());
    }

    public static MenuPanel getTheMenuPanel() {
        return theInstance;
    }

    public void setCandidateList(CandidateList candidates) {
        this.candidates = candidates;
    }

    public CandidateList getCandidateList() {
        return this.candidates;
    }

    public ArrayList getRawVotes() {
        return this.rawVotes;
    }

    public void setRawVotes(ArrayList rawVotes) {
        this.rawVotes = rawVotes;
    }

    public VoteSet getVoteSet() {
        return this.voteSet;
    }

    public void setVoteSet(VoteSet voteSet) {
        this.voteSet = voteSet;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        this.helpAdapter.setText(state);
        this.setEnabled(true);
    }

    public void setEnabled(boolean b) {
        JRootPane rootPane = this.getRootPane();
        if (!b) {
            this.setEnabled(false, false, false, false, false, false, false, false, false, false);
            rootPane.setDefaultButton(this.restartButton);
        } else {
            switch (this.state) {
                case 0: {
                    this.setEnabled(true, true, false, false, false, false, false, false, false, true);
                    if (rootPane != null) {
                        rootPane.setDefaultButton(this.clearButton);
                    }
                    this.clearButton.grabFocus();
                    break;
                }
                case 1: {
                    this.setEnabled(true, false, true, false, false, false, false, false, false, true);
                    if (rootPane != null) {
                        rootPane.setDefaultButton(this.importCandidatesButton);
                    }
                    this.importCandidatesButton.grabFocus();
                    break;
                }
                case 2: {
                    this.setEnabled(true, false, false, true, false, false, false, false, false, true);
                    if (rootPane != null) {
                        rootPane.setDefaultButton(this.importVotesButton);
                    }
                    this.importVotesButton.grabFocus();
                    break;
                }
                case 3: {
                    this.setEnabled(true, false, false, false, true, false, false, false, false, true);
                    if (rootPane != null) {
                        rootPane.setDefaultButton(this.importPrivateKeyButton);
                    }
                    this.importPrivateKeyButton.grabFocus();
                    break;
                }
                case 4: {
                    this.setEnabled(true, false, false, false, false, true, false, false, false, true);
                    if (rootPane != null) {
                        rootPane.setDefaultButton(this.importPublicKeyButton);
                    }
                    this.importPublicKeyButton.grabFocus();
                    break;
                }
                case 5: {
                    this.setEnabled(true, false, false, false, false, false, true, false, false, true);
                    if (rootPane != null) {
                        rootPane.setDefaultButton(this.decryptButton);
                    }
                    this.decryptButton.grabFocus();
                    break;
                }
                case 6: {
                    this.setEnabled(true, false, false, false, false, false, false, true, false, true);
                    if (rootPane != null) {
                        rootPane.setDefaultButton(this.countButton);
                    }
                    this.countButton.grabFocus();
                    break;
                }
                case 7: 
                case 8: {
                    this.setEnabled(true, false, false, false, false, false, false, false, true, true);
                    if (rootPane != null) {
                        rootPane.setDefaultButton(this.reportButton);
                    }
                    this.reportButton.grabFocus();
                }
            }
        }
    }

    private void setEnabled(boolean b0, boolean b1, boolean b2, boolean b3, boolean b4, boolean b5, boolean b6, boolean b7, boolean b8, boolean b9) {
        this.restartButton.setEnabled(b0);
        this.clearButton.setEnabled(b1);
        this.importCandidatesButton.setEnabled(b2);
        this.importVotesButton.setEnabled(b3);
        this.importPrivateKeyButton.setEnabled(b4);
        this.importPublicKeyButton.setEnabled(b5);
        this.decryptButton.setEnabled(b6);
        this.countButton.setEnabled(b7);
        this.reportButton.setEnabled(b8);
        this.exitButton.setEnabled(b9);
    }

    void setCurrentDir(File currentDir) {
        this.currentDir = currentDir;
    }

    File getCurrentDir() {
        return this.currentDir;
    }

    public void addExitButtonListener(ActionListener l) {
        this.exitButton.addActionListener(l);
    }

    public void clear() {
        if (this.candidates != null) {
            this.candidates.clear();
            this.candidates = null;
        }
        this.rawVotes = null;
        this.voteSet = null;
        this.privateKey = null;
        this.publicKey = null;
    }

    public static void main(String[] arg) {
        MenuPanel mp = MenuPanel.getTheMenuPanel();
        JFrame frame = new JFrame("Kiezen Op Afstand (v1.3)");
        Container c = frame.getContentPane();
        c.add(mp);
        frame.addWindowListener(new ExitAdapter());
        frame.pack();
        frame.setVisible(true);
    }
}

