/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sos.koa.AuditLog;
import sos.koa.Candidate;
import sos.koa.CandidateList;
import sos.koa.KOAException;
import sos.koa.KiesKring;
import sos.koa.KiesLijst;
import sos.koa.MenuPanel;
import sos.koa.Task;

public class ImportCandidatesAdapter
extends Task {
    CandidateList candidates;
    int taskCount;
    boolean keepRunning;
    static final /* synthetic */ boolean $assertionsDisabled;

    String getTitle() {
        return "Kandidaten importeren...";
    }

    String getSuccessMessage() {
        return "Importeren is gelukt!";
    }

    String getFailureMessage() {
        return "Importeren is mislukt!";
    }

    boolean isPreStateAllowed(int state) {
        return state == 1;
    }

    int getSuccessState() {
        return 2;
    }

    boolean isCancelableTask() {
        return true;
    }

    void doAction() throws KOAException {
        this.keepRunning = true;
        this.taskCount = 0;
        File file = this.popupGetFile(".xml", "Kandidaatbestanden (*.xml)");
        this.setMaxSubTasks((int)(2L * file.length() / 24L));
        new CandidateFileChecker().check(file);
        this.setMaxSubTasks(2 * this.taskCount);
        new CandidateFileParser().parse(file);
        MenuPanel.getTheMenuPanel().setCandidateList(this.candidates);
        this.candidates = null;
    }

    void stopAction() {
        this.keepRunning = false;
        this.clear();
    }

    void clear() {
        if (this.candidates != null) {
            this.candidates.clear();
        }
        if (MenuPanel.getTheMenuPanel().getCandidateList() != null) {
            MenuPanel.getTheMenuPanel().getCandidateList().clear();
        }
    }

    void logStarted() {
    }

    void logOpenedFile(File file) {
        Date candidateFileModification = new Date(file.lastModified());
        AuditLog.setImportCandidatesFileName(file.toString());
        AuditLog.setImportCandidatesFileTimestamp(candidateFileModification.toString());
    }

    void logFailed(String reason) {
        AuditLog.setImportCandidatesSuccess(false);
        AuditLog.setImportCandidatesError(reason);
    }

    void logCompleted() {
        AuditLog.setImportCandidatesSuccess(true);
    }

    boolean isAdditionalInfoAvailable() {
        return true;
    }

    Object getAdditionalInfo() {
        int height = Math.min(AuditLog.getImportCandidatesNrOfCandidates() + 5, 30);
        JTextArea area = new JTextArea(height, 30);
        area.setText(this.showCandidates());
        area.setEditable(false);
        return new JScrollPane(area);
    }

    String getInfo() {
        CandidateList candidates = MenuPanel.getTheMenuPanel().getCandidateList();
        byte totalPartyCount = candidates.totalPartyCount();
        int totalCandidates = 0;
        byte lijstCandidates = 0;
        byte totalBlanco = candidates.blancoCount();
        AuditLog.setImportCandidatesRefNr(candidates.my_metadata.requestReference() + File.separator + candidates.my_metadata.responseReference());
        Set orderedKiesKringen = candidates.my_kieskringen.keySet();
        if (!$assertionsDisabled && orderedKiesKringen == null) {
            throw new AssertionError();
        }
        Iterator i = orderedKiesKringen.iterator();
        if (!$assertionsDisabled && i == null) {
            throw new AssertionError();
        }
        StringBuffer info = new StringBuffer();
        while (i.hasNext()) {
            Byte b = (Byte)i.next();
            KiesKring kiesKring = (KiesKring)candidates.my_kieskringen.get(b);
            info.append("Kieskring ");
            info.append(kiesKring.number());
            info.append(" ");
            info.append(kiesKring.name());
            info.append("\n");
            info.append("Aantal lijsten (excl. blanco): ");
            info.append(kiesKring.kieslijstCount() - totalBlanco);
            info.append("\n\n");
            for (int j = 0; j < kiesKring.my_kiesLijsten.length; ++j) {
                if (kiesKring.my_kiesLijsten[j] == null) continue;
                lijstCandidates = kiesKring.my_kiesLijsten[j].candidateCount();
                totalCandidates += lijstCandidates;
                info.append("Lijst ");
                info.append(kiesKring.my_kiesLijsten[j].number());
                info.append(" ");
                info.append(kiesKring.my_kiesLijsten[j].name());
                info.append(": ");
                info.append(lijstCandidates);
                info.append("\n");
            }
        }
        info.append("\nTotaal aantal kandidaten (excl. blanco): ");
        info.append(totalCandidates - totalBlanco);
        info.append("\n");
        AuditLog.setImportCandidatesNrOfLists(totalPartyCount - totalBlanco);
        AuditLog.setImportCandidatesNrOfCandidates(totalCandidates - totalBlanco);
        AuditLog.setImportCandidatesNrOfBlanco(totalBlanco);
        return info.toString();
    }

    String showCandidates() {
        CandidateList candidates = MenuPanel.getTheMenuPanel().getCandidateList();
        StringBuffer allCandidates = new StringBuffer();
        Set orderedKiesKringen = candidates.my_kieskringen.keySet();
        if (!$assertionsDisabled && orderedKiesKringen == null) {
            throw new AssertionError();
        }
        Iterator i = orderedKiesKringen.iterator();
        if (!$assertionsDisabled && i == null) {
            throw new AssertionError();
        }
        while (i.hasNext()) {
            Byte b = (Byte)i.next();
            KiesKring kiesKring = (KiesKring)candidates.my_kieskringen.get(b);
            allCandidates.append("Kieskring ");
            allCandidates.append(kiesKring.number());
            allCandidates.append(" ");
            allCandidates.append(kiesKring.name());
            allCandidates.append("\n");
            allCandidates.append("Aantal lijsten (excl. blanco): ");
            allCandidates.append(kiesKring.kieslijstCount() - candidates.blancoCount());
            allCandidates.append("\n\n");
            for (int j = 0; j < kiesKring.getKiesLijsten().length; ++j) {
                KiesLijst kiesLijst = kiesKring.getKiesLijsten()[j];
                if (kiesLijst == null) continue;
                allCandidates.append("\nLijst ");
                allCandidates.append(kiesLijst.number());
                allCandidates.append(" ");
                allCandidates.append(kiesLijst.name());
                allCandidates.append(": ");
                allCandidates.append(kiesLijst.candidateCount());
                allCandidates.append("\n");
                for (int k = 0; k < kiesLijst.candidates().length; ++k) {
                    Candidate candidate = kiesLijst.candidates()[k];
                    if (candidate == null) continue;
                    allCandidates.append(candidate.position_number());
                    allCandidates.append(" ");
                    allCandidates.append(candidate.initials());
                    allCandidates.append(" ");
                    allCandidates.append(candidate.lastname());
                    allCandidates.append("\n");
                }
            }
        }
        return allCandidates.toString();
    }

    boolean isProgressMonitoredTask() {
        return true;
    }

    static {
        $assertionsDisabled = !ImportCandidatesAdapter.class.desiredAssertionStatus();
    }

    class CandidateFileParser
    extends DefaultHandler {
        Stack parserState;
        StringBuffer requestreference = new StringBuffer();
        StringBuffer responsereference = new StringBuffer();
        StringBuffer creationtime = new StringBuffer();
        StringBuffer kieskringcount = new StringBuffer();
        StringBuffer districtcount = new StringBuffer();
        StringBuffer kieslijstcount = new StringBuffer();
        StringBuffer positiecount = new StringBuffer();
        StringBuffer codecount = new StringBuffer();
        KiesKring kieskring;
        KiesLijst kieslijst;
        Candidate candidate;
        StringBuffer code = new StringBuffer();

        CandidateFileParser() {
        }

        void parse(File file) throws KOAException {
            try {
                this.parserState = new Stack();
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                parser.parse(file, (DefaultHandler)this);
            }
            catch (SAXException se) {
                throw new KOAException(se.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new KOAException(e);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("metadata")) {
                this.requestreference.setLength(0);
                this.responsereference.setLength(0);
                this.creationtime.setLength(0);
                this.kieskringcount.setLength(0);
                this.districtcount.setLength(0);
                this.kieslijstcount.setLength(0);
                this.positiecount.setLength(0);
                this.codecount.setLength(0);
            } else if (qName.equals("kieskring")) {
                int kieskringNumber = Integer.parseInt(attributes.getValue("nummer").trim());
                String kieskringName = attributes.getValue("naam");
                this.kieskring = ImportCandidatesAdapter.this.candidates.addKiesKring((byte)kieskringNumber, kieskringName);
            } else if (qName.equals("kieslijst")) {
                byte kieslijstNumber = (byte)Integer.parseInt(attributes.getValue("nummer").trim());
                String partyName = attributes.getValue("groepering").trim();
                this.kieslijst = ImportCandidatesAdapter.this.candidates.addKiesLijst(this.kieskring, kieslijstNumber, partyName);
            } else if (qName.equals("positie")) {
                String position = attributes.getValue("nummer");
                String lastname = attributes.getValue("achternaam");
                String initials = attributes.getValue("voorletters");
                String firstname = attributes.getValue("roepnaam");
                String gender = attributes.getValue("geslacht");
                String city = attributes.getValue("woonplaats");
                this.candidate = ImportCandidatesAdapter.this.candidates.addCandidate(this.kieskring, this.kieslijst, position, lastname, initials, firstname, gender, city);
            } else if (qName.equals("district")) {
                short districtNumber = (short)Integer.parseInt(attributes.getValue("nummer").trim());
                String districtName = attributes.getValue("naam").trim();
                ImportCandidatesAdapter.this.candidates.addDistrict(this.kieskring, districtNumber, districtName);
            } else if (qName.equals("code")) {
                if (!ImportCandidatesAdapter.this.keepRunning) {
                    throw new SAXException("Taak geannuleerd!");
                }
                this.code.setLength(0);
            }
            this.parserState.push(qName);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String qName = (String)this.parserState.peek();
            if (qName.equals("requestreference")) {
                this.requestreference.append(ch, start, length);
            } else if (qName.equals("responsereference")) {
                this.responsereference.append(ch, start, length);
            } else if (qName.equals("creationtime")) {
                this.creationtime.append(ch, start, length);
            } else if (qName.equals("kieskringcount")) {
                this.kieskringcount.append(ch, start, length);
            } else if (qName.equals("districtcount")) {
                this.districtcount.append(ch, start, length);
            } else if (qName.equals("kieslijstcount")) {
                this.kieslijstcount.append(ch, start, length);
            } else if (qName.equals("positiecount")) {
                this.positiecount.append(ch, start, length);
            } else if (qName.equals("codecount")) {
                this.codecount.append(ch, start, length);
            } else if (qName.equals("code")) {
                this.code.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("metadata")) {
                ImportCandidatesAdapter.this.candidates = new CandidateList(this.requestreference.toString(), this.responsereference.toString(), this.creationtime.toString(), this.kieskringcount.toString(), this.districtcount.toString(), this.kieslijstcount.toString(), this.positiecount.toString(), this.codecount.toString());
            } else if (qName.equals("code")) {
                if (!ImportCandidatesAdapter.this.candidates.addCandidateCode(this.candidate, this.code.toString())) {
                    throw new SAXException("Ongeldige kandidaatcode!");
                }
                ++ImportCandidatesAdapter.this.taskCount;
                if (ImportCandidatesAdapter.this.taskCount % 100 == 0) {
                    ImportCandidatesAdapter.this.setSubTaskCount(ImportCandidatesAdapter.this.taskCount);
                }
            }
            this.parserState.pop();
        }
    }

    class CandidateFileChecker
    extends DefaultHandler {
        int resultCount = 0;
        int metadataCount = 0;
        int kieskringCount = 0;
        int kieslijstCount = 0;
        int positieCount = 0;

        CandidateFileChecker() {
        }

        void check(File file) throws KOAException {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                parser.parse(file, (DefaultHandler)this);
                if (this.resultCount != 1) {
                    throw new SAXException("Geen <result> tag gevonden!");
                }
            }
            catch (SAXException se) {
                throw new KOAException("Ongeldig XML formaat!");
            }
            catch (Exception e) {
                throw new KOAException(e);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("result")) {
                ++this.resultCount;
                if (this.resultCount > 1) {
                    throw new SAXException("Illegale <result> tag!");
                }
            } else if (qName.equals("metadata")) {
                ++this.metadataCount;
                if (this.metadataCount > 1) {
                    throw new SAXException("Illegale <metadata> tag!");
                }
            } else if (!(qName.equals("requestreference") || qName.equals("responsereference") || qName.equals("creationtime") || qName.equals("kieskringcount") || qName.equals("districtcount") || qName.equals("kieslijstcount") || qName.equals("positiecount") || qName.equals("codecount"))) {
                if (qName.equals("kieskring")) {
                    ++this.kieskringCount;
                } else if (!qName.equals("district")) {
                    if (qName.equals("kieslijst")) {
                        ++this.kieslijstCount;
                    } else if (qName.equals("positie")) {
                        ++this.positieCount;
                    } else if (qName.equals("code")) {
                        if (!ImportCandidatesAdapter.this.keepRunning) {
                            throw new SAXException("Taak geannuleerd!");
                        }
                        ++ImportCandidatesAdapter.this.taskCount;
                        if (ImportCandidatesAdapter.this.taskCount % 100 == 0) {
                            ImportCandidatesAdapter.this.setSubTaskCount(ImportCandidatesAdapter.this.taskCount);
                        }
                    } else {
                        throw new SAXException("Onbekende tag: <" + qName + ">");
                    }
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }
}

