/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

public class Hex {
    private Hex() {
    }

    public static String byteToHexString(int n) {
        byte[] text = new byte[]{(byte)(n & 0xFF)};
        return Hex.bytesToHexString(text);
    }

    public static String shortToHexString(int n) {
        byte[] text = new byte[]{(byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        return Hex.bytesToHexString(text);
    }

    public static String intToHexString(int n) {
        byte[] text = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        return Hex.bytesToHexString(text);
    }

    public static String bytesToHexString(byte[] text) {
        return Hex.bytesToHexString(text, 0, text.length);
    }

    public static String bytesToHexString(byte[] text, int offset, int length) {
        String result = "";
        for (int i = 0; i < length; ++i) {
            int b = text[offset + i] & 0xFF;
            result = b < 16 ? result + "0" + Integer.toHexString(b) : result + Integer.toHexString(b);
        }
        return result.toUpperCase();
    }

    public static short hexStringToShort(String text) throws NumberFormatException {
        byte[] bytes = Hex.hexStringToBytes(text);
        if (bytes.length != 2) {
            throw new NumberFormatException();
        }
        return (short)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
    }

    public static byte[] hexStringToBytes(String text) throws NumberFormatException {
        if (text == null) {
            return null;
        }
        String hexchars = "0123456789abcdefABCDEF";
        StringBuffer hextext = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if ("0123456789abcdefABCDEF".indexOf(c) < 0) {
                throw new NumberFormatException();
            }
            hextext.append(c);
        }
        if (hextext.length() % 2 != 0) {
            hextext.insert(0, "0");
        }
        byte[] result = new byte[hextext.length() / 2];
        for (int i = 0; i < hextext.length(); i += 2) {
            int hi = Hex.hexCharToInt(hextext.charAt(i));
            int lo = Hex.hexCharToInt(hextext.charAt(i + 1));
            result[i / 2] = (byte)((hi & 0xFF) << 4 | lo & 0xFF);
        }
        return result;
    }

    private static int hexCharToInt(char c) throws NumberFormatException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new NumberFormatException();
    }
}

