/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import sos.koa.AuditLog;
import sos.koa.KOAException;
import sos.koa.MenuPanel;
import sos.koa.Task;
import sos.koa.VoteSet;

public class CountAdapter
extends Task {
    VoteSet voteSet;
    int votesCounted;
    boolean keepRunning;
    ArrayList errors;

    String getTitle() {
        return "Stemmen tellen...";
    }

    String getSuccessMessage() {
        if (this.errors != null && this.errors.size() > 0) {
            return "Tellen is gelukt!\n\n" + AuditLog.getImportVotesNrOfVotes() + " stem" + (AuditLog.getImportVotesNrOfVotes() != 1 ? "men" : "") + " ge\u00efmporteerd.\n" + AuditLog.getDecryptNrOfVotes() + " stem" + (AuditLog.getDecryptNrOfVotes() != 1 ? "men" : "") + " ontsleuteld.\n" + this.errors.size() + " stem" + (this.errors.size() != 1 ? "men" : "") + " genegeerd, zie meer info!";
        }
        return "Tellen is gelukt!\n\nGeen fouten opgetreden!";
    }

    String getFailureMessage() {
        return "Tellen is mislukt!";
    }

    boolean isPreStateAllowed(int state) {
        return state == 6;
    }

    int getSuccessState() {
        return 7;
    }

    void logStarted() {
        AuditLog.setCountTimestampStart(AuditLog.getCurrentTimestamp());
    }

    void logCompleted() {
        AuditLog.setCountSuccess(true);
        AuditLog.setCountNrOfVotes(this.votesCounted);
        AuditLog.setCountTimestampEnd(AuditLog.getCurrentTimestamp());
        AuditLog.setCountErrors(this.getErrors());
    }

    void logFailed(String reason) {
        AuditLog.setCountSuccess(false);
        String[] err = new String[]{reason};
        AuditLog.setCountErrors(err);
    }

    boolean isProgressMonitoredTask() {
        return true;
    }

    public void doAction() throws KOAException {
        this.errors = new ArrayList();
        this.votesCounted = 0;
        this.voteSet = new VoteSet(MenuPanel.getTheMenuPanel().getCandidateList());
        this.voteSet.initializeVote();
        this.voteSet.resetVotes();
        ArrayList rawVotes = MenuPanel.getTheMenuPanel().getRawVotes();
        this.setMaxSubTasks(rawVotes.size());
        this.keepRunning = true;
        for (int i = 0; i < rawVotes.size(); ++i) {
            block10: {
                if (!this.keepRunning) {
                    throw new KOAException("Taak geannuleerd!");
                }
                try {
                    String vote = (String)rawVotes.get(i);
                    if (vote.startsWith("DECRYPTERROR")) break block10;
                    String[] parts = vote.split(";");
                    if (parts.length < 8) {
                        throw new KOAException("Rij index " + i + ": Niet alle redundante informatie gevonden!");
                    }
                    for (int j = 0; j < parts.length; ++j) {
                        if (!parts[j].equals("null")) continue;
                        parts[j] = null;
                    }
                    if (!this.voteSet.validCandidate(parts[0])) {
                        throw new KOAException("Rij index " + i + ": Geen kandidaat gevonden met code " + parts[0] + "!");
                    }
                    if (this.voteSet.validateRedundantInfo(parts[0], parts[1], parts[2], parts[6], parts[5], parts[3])) {
                        if (this.voteSet.validateKiesKringNumber(parts[0], parts[7])) {
                            this.voteSet.addVote(parts[0]);
                            ++this.votesCounted;
                            break block10;
                        }
                        throw new KOAException("Rij index " + i + ": Kandidaat " + parts[0] + "; Ongeldig kieskringnummer!");
                    }
                    throw new KOAException("Rij index " + i + ": Kandidaat " + parts[0] + "; Ongeldige redundante informatie!");
                }
                catch (KOAException e) {
                    this.errors.add(e.getMessage());
                }
                catch (Exception e) {
                    this.errors.add("Rij index " + i + ": Onbekende fout tijdens tellen.");
                }
            }
            if (i % 10 != 0) continue;
            this.setSubTaskCount(i);
        }
        this.voteSet.finalizeVote();
        MenuPanel.getTheMenuPanel().setVoteSet(this.voteSet);
        this.voteSet = null;
    }

    void stopAction() {
        this.keepRunning = false;
    }

    String getInfo() {
        return Integer.toString(this.votesCounted) + " stem" + (this.votesCounted != 1 ? "men" : "") + " geteld.";
    }

    Object getAdditionalInfo() {
        int height = Math.min(this.errors.size() + 5, 30);
        JTextArea area = new JTextArea(height, 30);
        StringBuffer additionalInfo = new StringBuffer();
        if (this.errors.size() > 0) {
            additionalInfo.append("De volgende fouten zijn geconstateerd:\n");
            for (int i = 0; i < this.errors.size(); ++i) {
                additionalInfo.append(this.errors.get(i).toString());
                additionalInfo.append("\n");
            }
        } else {
            additionalInfo.append("Er zijn geen fouten opgetreden bij het tellen.");
        }
        area.setText(additionalInfo.toString());
        area.setEditable(false);
        return new JScrollPane(area);
    }

    boolean isAdditionalInfoAvailable() {
        return true;
    }

    String[] getErrors() {
        String[] result = new String[this.errors.size()];
        this.errors.toArray(result);
        return result;
    }
}

