/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERUniversalString
extends DERObject
implements DERString {
    byte[] string;
    char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static DERUniversalString getInstance(Object object) {
        if (object == null || object instanceof DERUniversalString) {
            return (DERUniversalString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERUniversalString(((ASN1OctetString)object).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERUniversalString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERUniversalString(byte[] byArray) {
        this.string = byArray;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n != this.string.length) {
            stringBuffer.append(this.table[(this.string[n] >>> 4) % 15]);
            stringBuffer.append(this.table[this.string[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public byte[] getOctets() {
        return this.string;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(28, this.getOctets());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERUniversalString)) {
            return false;
        }
        return this.getString().equals(((DERUniversalString)object).getString());
    }
}

