/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.TextState;

public abstract class FObjMixed
extends FObj {
    protected TextState textState;
    private StringBuffer textBuffer;

    protected FObjMixed(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        this.textState = this.propMgr.getTextDecoration(parent);
    }

    public TextState getTextState() {
        return this.textState;
    }

    protected void addCharacters(char[] data, int start, int length) {
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer();
        }
        this.textBuffer.append(data, start, length);
    }

    private final void finalizeText() {
        if (this.textBuffer != null && this.textBuffer.length() > 0) {
            FOText ft = new FOText(this.textBuffer, this);
            ft.setTextState(this.textState);
            super.addChild(ft);
            this.textBuffer.setLength(0);
        }
    }

    protected void end() {
        this.finalizeText();
        this.textBuffer = null;
    }

    protected void addChild(FONode child) {
        this.finalizeText();
        super.addChild(child);
    }

    public int layout(Area area) throws FOPException {
        Property prop;
        if (this.properties != null && (prop = this.properties.get("id")) != null) {
            String id = prop.getString();
            if (this.marker == -1000) {
                if (area.getIDReferences() != null) {
                    try {
                        area.getIDReferences().createID(id);
                    }
                    catch (FOPException e) {
                        if (!e.isLocationSet()) {
                            e.setLocation(this.systemId, this.line, this.column);
                        }
                        throw e;
                    }
                }
                this.marker = 0;
            }
            if (this.marker == 0 && area.getIDReferences() != null) {
                area.getIDReferences().configureID(id, area);
            }
        }
        int numChildren = this.children.size();
        for (int i = this.marker; i < numChildren; ++i) {
            FONode fo = (FONode)this.children.get(i);
            int status = fo.layout(area);
            if (!Status.isIncomplete(status)) continue;
            this.marker = i;
            return status;
        }
        return 1;
    }
}

