/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.fop.messaging.MessageHandler;

public class Configuration {
    public static final int STANDARD = 0;
    public static final int PDF = 1;
    public static final int AWT = 2;
    private static Map standardConfiguration = new HashMap(30);
    private static Map pdfConfiguration = new HashMap(20);
    private static Map awtConfiguration = new HashMap(20);
    private static Map configuration = new HashMap(3);
    private static URL cachedBaseURL = null;
    private static URL cachedFontBaseURL = null;

    public static Map getConfiguration() {
        return configuration;
    }

    public static Object getValue(String key, int role) {
        switch (role) {
            case 0: {
                return standardConfiguration.get(key);
            }
            case 1: {
                return pdfConfiguration.get(key);
            }
            case 2: {
                return awtConfiguration.get(key);
            }
        }
        return standardConfiguration.get(key);
    }

    public static String getStringValue(String key, int role) {
        Object obj = Configuration.getValue(key, role);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public static int getIntValue(String key, int role) {
        Object obj = Configuration.getValue(key, role);
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        return -1;
    }

    public static Boolean getBooleanValue(String key, int role) {
        Object obj = Configuration.getValue(key, role);
        if (obj instanceof String) {
            return new Boolean((String)obj);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return null;
    }

    public static List getListValue(String key, int role) {
        Object obj = Configuration.getValue(key, role);
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    public static Map getMapValue(String key, int role) {
        Object obj = Configuration.getValue(key, role);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    public static Object getValue(String key) {
        return Configuration.getValue(key, 0);
    }

    public static String getStringValue(String key) {
        return Configuration.getStringValue(key, 0);
    }

    public static int getIntValue(String key) {
        return Configuration.getIntValue(key, 0);
    }

    public static Boolean getBooleanValue(String key) {
        return Configuration.getBooleanValue(key, 0);
    }

    public static List getListValue(String key) {
        return Configuration.getListValue(key, 0);
    }

    public static Map getMapValue(String key) {
        return Configuration.getMapValue(key, 0);
    }

    public static List getFonts() {
        return (List)Configuration.getValue("fonts", 0);
    }

    private static URL buildBaseURL(String directory) throws MalformedURLException {
        if (directory == null) {
            return null;
        }
        File dir = new File(directory);
        if (dir.isDirectory()) {
            return dir.toURL();
        }
        URL baseURL = new URL(directory);
        return baseURL;
    }

    public static URL getBaseURL() {
        if (cachedBaseURL != null) {
            return cachedBaseURL;
        }
        String baseDir = Configuration.getStringValue("baseDir");
        try {
            URL url;
            cachedBaseURL = url = Configuration.buildBaseURL(baseDir);
            return url;
        }
        catch (MalformedURLException mfue) {
            throw new RuntimeException("Invalid baseDir specified: " + baseDir + " (" + mfue.getMessage() + ")");
        }
    }

    public static URL getFontBaseURL() {
        if (cachedFontBaseURL != null) {
            return cachedFontBaseURL;
        }
        URL url = null;
        String baseDir = Configuration.getStringValue("fontBaseDir");
        if (baseDir == null) {
            url = Configuration.getBaseURL();
        } else {
            try {
                url = Configuration.buildBaseURL(baseDir);
            }
            catch (MalformedURLException mfue) {
                throw new RuntimeException("Invalid fontBaseDir specified: " + baseDir + " (" + mfue.getMessage() + ")");
            }
        }
        cachedFontBaseURL = url;
        return url;
    }

    public static void setup(int role, Map config) {
        switch (role) {
            case 0: {
                standardConfiguration = config;
                break;
            }
            case 1: {
                pdfConfiguration = config;
                break;
            }
            case 2: {
                awtConfiguration = config;
                break;
            }
            default: {
                MessageHandler.errorln("Can't setup configuration. Unknown configuration role/target");
            }
        }
        Configuration.invalidateURLCache();
    }

    public static void put(String key, Object value, int role) {
        switch (role) {
            case 0: {
                standardConfiguration.put(key, value);
                break;
            }
            case 1: {
                pdfConfiguration.put(key, value);
                break;
            }
            case 2: {
                awtConfiguration.put(key, value);
                break;
            }
            default: {
                standardConfiguration.put(key, value);
                MessageHandler.errorln("Unknown role for new configuration entry. Putting key:" + key + " - value:" + value + " into standard configuration.");
            }
        }
        Configuration.invalidateURLCache();
    }

    public static void put(String key, Object value) {
        Configuration.put(key, value, 0);
    }

    private static void invalidateURLCache() {
        cachedBaseURL = null;
        cachedFontBaseURL = null;
    }

    public static void dumpConfiguration() {
        System.out.println("Dumping configuration: ");
        Map[] configs = new Map[]{standardConfiguration, pdfConfiguration, awtConfiguration};
        for (int i = 0; i < configs.length; ++i) {
            MessageHandler.logln("----------------------");
            Map configuration = configs[i];
            Iterator iterator = configuration.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                MessageHandler.logln("key: " + key);
                Object value = configuration.get(key);
                if (value instanceof String) {
                    MessageHandler.logln("   value: " + value);
                    continue;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    MessageHandler.log("   values: ");
                    for (int j = 0; j < list.size(); ++j) {
                        MessageHandler.log(list.get(j) + " - ");
                    }
                    MessageHandler.logln("");
                    continue;
                }
                if (!(value instanceof Map)) continue;
                Map map = (Map)value;
                MessageHandler.log("   values: ");
                Iterator it2 = map.keySet().iterator();
                while (it2.hasNext()) {
                    String tmp = (String)it2.next();
                    MessageHandler.log(" " + tmp + ":" + map.get(tmp));
                }
                MessageHandler.logln("");
            }
        }
    }

    static {
        configuration.put("standard", standardConfiguration);
        configuration.put("pdf", pdfConfiguration);
        configuration.put("awt", awtConfiguration);
    }
}

