/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.fop.apps.AWTStarter;
import org.apache.fop.apps.FOPException;
import org.apache.fop.messaging.MessageEvent;
import org.apache.fop.messaging.MessageListener;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.Command;
import org.apache.fop.viewer.GoToPageDialog;
import org.apache.fop.viewer.IconToolBar;
import org.apache.fop.viewer.PreviewDialogAboutBox;
import org.apache.fop.viewer.ProgressListener;
import org.apache.fop.viewer.Translator;

public class PreviewDialog
extends JFrame
implements ProgressListener,
MessageListener {
    protected Translator res;
    protected int currentPage = 0;
    protected int pageCount = 0;
    protected AWTRenderer renderer;
    protected AWTStarter starter;
    protected IconToolBar toolBar = new IconToolBar();
    protected Command printAction;
    protected Command firstPageAction;
    protected Command previousPageAction;
    protected Command nextPageAction;
    protected Command lastPageAction;
    protected Command reloadAction;
    protected Reloader reloader;
    protected JLabel zoomLabel = new JLabel();
    protected JComboBox scale = new JComboBox(){

        public float getAlignmentY() {
            return 0.5f;
        }
    };
    protected JScrollPane previewArea = new JScrollPane();
    protected JPanel statusBar = new JPanel();
    protected GridBagLayout statusBarLayout = new GridBagLayout();
    protected JLabel statisticsStatus = new JLabel();
    protected JLabel processStatus = new JLabel();
    protected JLabel infoStatus = new JLabel();
    protected JLabel previewImageLabel = new JLabel();

    public PreviewDialog(AWTStarter aStarter, AWTRenderer aRenderer, Translator aRes) {
        this(aRenderer, aRes);
        this.starter = aStarter;
    }

    public PreviewDialog(AWTRenderer aRenderer, Translator aRes) {
        this.res = aRes;
        this.renderer = aRenderer;
        this.printAction = new Command(this.res.getString("Print"), "Print"){

            public void doit() {
                PreviewDialog.this.print();
            }
        };
        this.firstPageAction = new Command(this.res.getString("First page"), "firstpg"){

            public void doit() {
                PreviewDialog.this.goToFirstPage(null);
            }
        };
        this.previousPageAction = new Command(this.res.getString("Previous page"), "prevpg"){

            public void doit() {
                PreviewDialog.this.goToPreviousPage(null);
            }
        };
        this.nextPageAction = new Command(this.res.getString("Next page"), "nextpg"){

            public void doit() {
                PreviewDialog.this.goToNextPage(null);
            }
        };
        this.lastPageAction = new Command(this.res.getString("Last page"), "lastpg"){

            public void doit() {
                PreviewDialog.this.goToLastPage(null);
            }
        };
        this.reloadAction = new Command(this.res.getString("Reload"), "reload"){

            public void doit() {
                PreviewDialog.this.reload(null);
            }
        };
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(379, 476));
        this.previewArea.setMinimumSize(new Dimension(50, 50));
        this.setTitle("FOP: AWT-" + this.res.getString("Preview"));
        this.scale.addItem("25");
        this.scale.addItem("50");
        this.scale.addItem("75");
        this.scale.addItem("100");
        this.scale.addItem("150");
        this.scale.addItem("200");
        this.scale.setMaximumSize(new Dimension(80, 24));
        this.scale.setPreferredSize(new Dimension(80, 24));
        this.scale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewDialog.this.scale_actionPerformed(e);
            }
        });
        this.scale.setSelectedItem("100");
        this.renderer.setScaleFactor(100.0);
        this.zoomLabel.setText(this.res.getString("Zoom"));
        this.setJMenuBar(this.setupMenue());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.toolBar.add(this.printAction);
        this.toolBar.add(this.reloadAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.firstPageAction);
        this.toolBar.add(this.previousPageAction);
        this.toolBar.add(this.nextPageAction);
        this.toolBar.add(this.lastPageAction);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.zoomLabel, null);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.scale, null);
        this.getContentPane().add((Component)this.previewArea, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.statisticsStatus.setBorder(BorderFactory.createEtchedBorder());
        this.processStatus.setBorder(BorderFactory.createEtchedBorder());
        this.infoStatus.setBorder(BorderFactory.createEtchedBorder());
        this.statusBar.setLayout(this.statusBarLayout);
        this.processStatus.setPreferredSize(new Dimension(200, 21));
        this.statisticsStatus.setPreferredSize(new Dimension(100, 21));
        this.infoStatus.setPreferredSize(new Dimension(100, 21));
        this.processStatus.setMinimumSize(new Dimension(200, 21));
        this.statisticsStatus.setMinimumSize(new Dimension(100, 21));
        this.infoStatus.setMinimumSize(new Dimension(100, 21));
        this.statusBar.add((Component)this.processStatus, new GridBagConstraints(0, 0, 2, 1, 2.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.statusBar.add((Component)this.statisticsStatus, new GridBagConstraints(2, 0, 1, 2, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.statusBar.add((Component)this.infoStatus, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.previewArea.getViewport().add(this.previewImageLabel);
        this.showPage();
    }

    private JMenuBar setupMenue() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(this.res.getString("File"));
        JMenu subMenu = new JMenu("OutputFormat");
        subMenu.add(new Command("mHTML"));
        subMenu.add(new Command("mPDF"));
        subMenu.add(new Command("mRTF"));
        subMenu.add(new Command("mTEXT"));
        menu.add(new Command(this.res.getString("Print")){

            public void doit() {
                PreviewDialog.this.print();
            }
        });
        menu.add(new Command(this.res.getString("Reload")){

            public void doit() {
                PreviewDialog.this.reload(null);
            }
        });
        menu.addSeparator();
        menu.add(new Command(this.res.getString("Exit")){

            public void doit() {
                PreviewDialog.this.dispose();
            }
        });
        menuBar.add(menu);
        menu = new JMenu(this.res.getString("View"));
        menu.add(new Command(this.res.getString("First page")){

            public void doit() {
                PreviewDialog.this.goToFirstPage(null);
            }
        });
        menu.add(new Command(this.res.getString("Previous page")){

            public void doit() {
                PreviewDialog.this.goToPreviousPage(null);
            }
        });
        menu.add(new Command(this.res.getString("Next page")){

            public void doit() {
                PreviewDialog.this.goToNextPage(null);
            }
        });
        menu.add(new Command(this.res.getString("Last page")){

            public void doit() {
                PreviewDialog.this.goToLastPage(null);
            }
        });
        menu.add(new Command(this.res.getString("Go to Page") + " ..."){

            public void doit() {
                PreviewDialog.this.goToPage(null);
            }
        });
        menu.addSeparator();
        subMenu = new JMenu(this.res.getString("Zoom"));
        subMenu.add(new Command("25%"){

            public void doit() {
                PreviewDialog.this.setScale(25.0);
            }
        });
        subMenu.add(new Command("50%"){

            public void doit() {
                PreviewDialog.this.setScale(50.0);
            }
        });
        subMenu.add(new Command("75%"){

            public void doit() {
                PreviewDialog.this.setScale(75.0);
            }
        });
        subMenu.add(new Command("100%"){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        subMenu.add(new Command("150%"){

            public void doit() {
                PreviewDialog.this.setScale(150.0);
            }
        });
        subMenu.add(new Command("200%"){

            public void doit() {
                PreviewDialog.this.setScale(200.0);
            }
        });
        menu.add(subMenu);
        menu.addSeparator();
        menu.add(new Command(this.res.getString("Default zoom")){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        menuBar.add(menu);
        menu = new JMenu(this.res.getString("Help"));
        menu.add(new Command(this.res.getString("Index")));
        menu.addSeparator();
        menu.add(new Command(this.res.getString("Introduction")));
        menu.addSeparator();
        menu.add(new Command(this.res.getString("About")){

            public void doit() {
                PreviewDialog.this.startHelpAbout(null);
            }
        });
        menuBar.add(menu);
        return menuBar;
    }

    public void startHelpAbout(ActionEvent e) {
        PreviewDialogAboutBox dlg = new PreviewDialogAboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }

    private void goToPage(int number) {
        this.currentPage = number;
        this.renderer.setPageNumber(number);
        this.showPage();
    }

    private void goToPreviousPage(ActionEvent e) {
        if (this.currentPage <= 0) {
            return;
        }
        --this.currentPage;
        this.goToPage(this.currentPage);
    }

    private void goToNextPage(ActionEvent e) {
        if (this.currentPage >= this.pageCount - 1) {
            return;
        }
        ++this.currentPage;
        this.goToPage(this.currentPage);
    }

    private void goToLastPage(ActionEvent e) {
        if (this.currentPage == this.pageCount - 1) {
            return;
        }
        this.currentPage = this.pageCount - 1;
        this.goToPage(this.currentPage);
    }

    private synchronized void reload(ActionEvent e) {
        if (this.reloader == null || !this.reloader.isAlive()) {
            this.reloader = new Reloader();
            this.reloader.start();
        }
    }

    private void goToPage(ActionEvent e) {
        GoToPageDialog d = new GoToPageDialog((Frame)this, this.res.getString("Go to Page"), true, this.res);
        d.setLocation((int)this.getLocation().getX() + 50, (int)this.getLocation().getY() + 50);
        d.show();
        this.currentPage = d.getPageNumber();
        if (this.currentPage < 1 || this.currentPage > this.pageCount) {
            return;
        }
        --this.currentPage;
        this.goToPage(this.currentPage);
    }

    private void goToFirstPage(ActionEvent e) {
        if (this.currentPage == 0) {
            return;
        }
        this.currentPage = 0;
        this.goToPage(this.currentPage);
    }

    private void print() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPageable(this.renderer);
        if (pj.printDialog()) {
            try {
                pj.print();
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    }

    public void setScale(double scaleFactor) {
        if (scaleFactor == 25.0) {
            this.scale.setSelectedIndex(0);
        } else if (scaleFactor == 50.0) {
            this.scale.setSelectedIndex(1);
        } else if (scaleFactor == 75.0) {
            this.scale.setSelectedIndex(2);
        } else if (scaleFactor == 100.0) {
            this.scale.setSelectedIndex(3);
        } else if (scaleFactor == 150.0) {
            this.scale.setSelectedIndex(4);
        } else if (scaleFactor == 200.0) {
            this.scale.setSelectedIndex(5);
        }
        this.renderer.setScaleFactor(scaleFactor);
        this.showPage();
    }

    void scale_actionPerformed(ActionEvent e) {
        this.setScale(new Double((String)this.scale.getSelectedItem()));
    }

    public void progress(int percentage) {
        this.progress(new String(percentage + "%"));
    }

    public void progress(int percentage, String message) {
        this.progress(new String(message + " " + percentage + "%"));
    }

    public void progress(String message) {
        SwingUtilities.invokeLater(new showProgress(message, false));
    }

    public void showPage() {
        showPageImage viewer = new showPageImage();
        if (SwingUtilities.isEventDispatchThread()) {
            viewer.run();
        } else {
            SwingUtilities.invokeLater(viewer);
        }
    }

    public void processMessage(MessageEvent event) {
        String error = event.getMessage();
        String text = this.processStatus.getText();
        FontMetrics fmt = this.processStatus.getFontMetrics(this.processStatus.getFont());
        int width = this.processStatus.getWidth() - fmt.stringWidth("...");
        if (event.getMessageType() == 0) {
            if (!text.endsWith("\n")) {
                text = text + error;
                while (fmt.stringWidth(text) > width) {
                    text = text.substring(1);
                    width = this.processStatus.getWidth() - fmt.stringWidth("...");
                }
            } else {
                text = error;
            }
            this.progress(text);
        } else {
            showProgress showIt;
            if ((error = error.trim()).equals(">")) {
                text = text + error;
                while (fmt.stringWidth(text) > width) {
                    text = text.substring(1);
                    width = this.processStatus.getWidth() - fmt.stringWidth("...");
                }
                this.progress(this.processStatus.getText() + error);
                return;
            }
            if (error.equals("")) {
                return;
            }
            if (error.length() < 60) {
                showIt = new showProgress(error, true);
            } else {
                StringTokenizer tok = new StringTokenizer(error, " ");
                Vector<String> labels = new Vector<String>();
                StringBuffer buffer = new StringBuffer();
                while (tok.hasMoreTokens()) {
                    String tmp = tok.nextToken();
                    if (buffer.length() + tmp.length() + 1 < 60) {
                        buffer.append(" ").append(tmp);
                        continue;
                    }
                    labels.add(buffer.toString());
                    buffer = new StringBuffer();
                    buffer.append(tmp);
                }
                labels.add(buffer.toString());
                String[] list = new String[labels.size()];
                for (int i = 0; i < labels.size(); ++i) {
                    list[i] = labels.get(i).toString();
                }
                showIt = new showProgress(list, true);
            }
            if (SwingUtilities.isEventDispatchThread()) {
                showIt.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(showIt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.progress(event.getMessage());
                }
            }
        }
    }

    public void reportException(Exception e) {
        String msg = this.res.getString("An exception has occured");
        this.progress(msg);
        JOptionPane.showMessageDialog(this.getContentPane(), "<html><b>" + msg + ":</b><br>" + e.getClass().getName() + "<br>" + e.getMessage() + "</html>", this.res.getString("Fatal error"), 0);
    }

    class showPageImage
    implements Runnable {
        showPageImage() {
        }

        public void run() {
            BufferedImage pageImage = null;
            Graphics graphics = null;
            PreviewDialog.this.renderer.render(PreviewDialog.this.currentPage);
            pageImage = PreviewDialog.this.renderer.getLastRenderedPage();
            if (pageImage == null) {
                return;
            }
            graphics = pageImage.getGraphics();
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, pageImage.getWidth() - 1, pageImage.getHeight() - 1);
            PreviewDialog.this.previewImageLabel.setIcon(new ImageIcon(pageImage));
            PreviewDialog.this.pageCount = PreviewDialog.this.renderer.getPageCount();
            PreviewDialog.this.statisticsStatus.setText(PreviewDialog.this.res.getString("Page") + " " + (PreviewDialog.this.currentPage + 1) + " " + PreviewDialog.this.res.getString("of") + " " + PreviewDialog.this.pageCount);
        }
    }

    class showProgress
    implements Runnable {
        Object message;
        boolean isErrorMessage = false;

        public showProgress(Object message, boolean isErrorMessage) {
            this.message = message;
            this.isErrorMessage = isErrorMessage;
        }

        public void run() {
            if (this.isErrorMessage) {
                JOptionPane.showMessageDialog(null, this.message, "Error", 0);
            } else {
                PreviewDialog.this.processStatus.setText(this.message.toString());
            }
        }
    }

    private class Reloader
    extends Thread {
        private Reloader() {
        }

        public void run() {
            PreviewDialog.this.previewImageLabel.setIcon(null);
            PreviewDialog.this.statisticsStatus.setText("");
            while (PreviewDialog.this.renderer.getPageCount() != 0) {
                PreviewDialog.this.renderer.removePage(0);
            }
            try {
                PreviewDialog.this.starter.run();
            }
            catch (FOPException e) {
                e.printStackTrace();
            }
        }
    }
}

