/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import sos.koa.FileNameFilter;
import sos.koa.KOAConstants;
import sos.koa.KOAException;
import sos.koa.MenuPanel;

public abstract class Task
implements KOAConstants,
ActionListener {
    int subTaskCount;
    int maxSubTasks;
    boolean success;
    boolean stillWorking;
    ProgressMonitor monitor;

    Task() {
    }

    boolean isDangerousTask() {
        return false;
    }

    boolean isProgressMonitoredTask() {
        return false;
    }

    boolean isModalTask() {
        return true;
    }

    boolean isCancelableTask() {
        return false;
    }

    void setSubTaskCount(int subTaskCount) {
        this.subTaskCount = subTaskCount;
    }

    String getInfo() {
        return "";
    }

    boolean isAdditionalInfoAvailable() {
        return false;
    }

    Object getAdditionalInfo() {
        return null;
    }

    void setMaxSubTasks(int maxSubTasks) {
        this.maxSubTasks = maxSubTasks;
        if (this.monitor != null) {
            this.monitor.setMaximum(maxSubTasks);
        }
    }

    abstract String getTitle();

    abstract String getSuccessMessage();

    abstract String getFailureMessage();

    String getWarningMessage() {
        return "";
    }

    abstract boolean isPreStateAllowed(int var1);

    abstract int getSuccessState();

    public void actionPerformed(ActionEvent ae) {
        if (this.isProgressMonitoredTask()) {
            new MonitoredThread().start();
        } else {
            new ActionThread().start();
        }
    }

    abstract void doAction() throws KOAException;

    void stopAction() {
    }

    void clear() {
    }

    void logStarted() {
    }

    void logCanceled() {
    }

    void logOpenedFile(File file) {
    }

    void logFailed(String reason) {
    }

    void logCompleted() {
    }

    File popupGetFile(String extension, String description) throws KOAException {
        try {
            File currentDir = MenuPanel.getTheMenuPanel().getCurrentDir();
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(this.getTitle());
            chooser.setCurrentDirectory(currentDir);
            chooser.setFileHidingEnabled(false);
            chooser.setFileFilter(new FileNameFilter(extension, description));
            int n = chooser.showOpenDialog(MenuPanel.getTheMenuPanel());
            if (n != 0) {
                throw new KOAException("File selecteren geannuleerd!");
            }
            File file = chooser.getSelectedFile();
            MenuPanel.getTheMenuPanel().setCurrentDir(file.getParentFile());
            this.logOpenedFile(file);
            return file;
        }
        catch (KOAException ke) {
            throw new KOAException(ke.getMessage());
        }
        catch (Exception e) {
            throw new KOAException("Onbekende fout tijdens dialoog!");
        }
    }

    String popupGetPassword() {
        try {
            String result = JOptionPane.showInputDialog(MenuPanel.getTheMenuPanel(), (Object)"Geef het password");
            if (result == null) {
                return "";
            }
            return result;
        }
        catch (Exception e) {
            return "";
        }
    }

    void popupSuccess() {
        try {
            int n = -1;
            if (this.isAdditionalInfoAvailable()) {
                while (n == -1 || n == 1) {
                    n = JOptionPane.showOptionDialog(MenuPanel.getTheMenuPanel(), this.getSuccessMessage() + "\n\n" + this.getInfo(), this.getTitle(), 0, 1, null, OK_MOREINFO_OPTIONS, OK_MOREINFO_OPTIONS[0]);
                    if (n != 1) continue;
                    this.popupAdditionalInfo();
                }
            } else {
                JOptionPane.showMessageDialog(MenuPanel.getTheMenuPanel(), this.getSuccessMessage() + "\n\n" + this.getInfo(), this.getTitle(), 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean popupWarning() {
        try {
            int n = JOptionPane.showOptionDialog(MenuPanel.getTheMenuPanel(), this.getWarningMessage(), this.getTitle(), 0, 3, null, YES_CANCEL_OPTIONS, YES_CANCEL_OPTIONS[0]);
            return n == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean popupNextOrBack() {
        try {
            int n = -1;
            if (this.isAdditionalInfoAvailable()) {
                while (n == -1 || n == 1 || n == 1) {
                    n = JOptionPane.showOptionDialog(MenuPanel.getTheMenuPanel(), this.getSuccessMessage() + "\n\n" + this.getInfo(), this.getTitle(), 0, 1, null, OK_MOREINFO_CANCEL_OPTIONS, OK_MOREINFO_CANCEL_OPTIONS[0]);
                    if (n != 1) continue;
                    n = this.popupAdditionalInfo(OK_LESSINFO_CANCEL_OPTIONS);
                }
            } else {
                n = JOptionPane.showOptionDialog(MenuPanel.getTheMenuPanel(), this.getSuccessMessage() + "\n\n" + this.getInfo(), this.getTitle(), 0, 1, null, OK_CANCEL_OPTIONS, OK_CANCEL_OPTIONS[0]);
            }
            return n == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean popupNext() {
        try {
            int n = -1;
            if (this.isAdditionalInfoAvailable()) {
                while (n == -1 || n == 1 || n == 1) {
                    n = JOptionPane.showOptionDialog(MenuPanel.getTheMenuPanel(), this.getSuccessMessage() + "\n\n" + this.getInfo(), this.getTitle(), 0, 1, null, OK_MOREINFO_OPTIONS, OK_MOREINFO_OPTIONS[0]);
                    if (n != 1) continue;
                    n = this.popupAdditionalInfo(OK_LESSINFO_OPTIONS);
                }
            } else {
                JOptionPane.showMessageDialog(MenuPanel.getTheMenuPanel(), this.getSuccessMessage() + "\n\n" + this.getInfo(), this.getTitle(), 1);
                n = 0;
            }
            return n == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    void popupFailure(String info) {
        try {
            JOptionPane.showMessageDialog(MenuPanel.getTheMenuPanel(), this.getFailureMessage() + "\n\n" + info, this.getTitle(), 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void popupAdditionalInfo() {
        try {
            JOptionPane.showMessageDialog(MenuPanel.getTheMenuPanel(), this.getAdditionalInfo(), this.getTitle(), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    int popupAdditionalInfo(Object[] options) {
        try {
            return JOptionPane.showOptionDialog(MenuPanel.getTheMenuPanel(), this.getAdditionalInfo(), this.getTitle(), 0, 1, null, options, options[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    class ActionThread
    extends Thread {
        ActionThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block33: {
                int preCursorType = MenuPanel.getTheMenuPanel().getCursor().getType();
                String reason = "Onbekende fout!";
                if (Task.this.isModalTask()) {
                    MenuPanel.getTheMenuPanel().setEnabled(false);
                }
                Task.this.success = false;
                try {
                    try {
                        Task.this.logStarted();
                        if (Task.this.isDangerousTask() && !Task.this.popupWarning()) {
                            throw new KOAException("Taak geannuleerd!");
                        }
                        MenuPanel.getTheMenuPanel().setCursor(new Cursor(3));
                        Task.this.doAction();
                        Task.this.success = true;
                    }
                    catch (KOAException ke) {
                        reason = ke.getMessage();
                        Task.this.logFailed(reason);
                        Object var5_4 = null;
                        Task.this.stillWorking = false;
                        MenuPanel.getTheMenuPanel().setCursor(new Cursor(preCursorType));
                        if (!Task.this.isModalTask()) break block33;
                        if (Task.this.success) {
                            if (Task.this.isCancelableTask()) {
                                if (Task.this.popupNextOrBack()) {
                                    Task.this.logCompleted();
                                    MenuPanel.getTheMenuPanel().setState(Task.this.getSuccessState());
                                } else {
                                    reason = "Taak geannuleerd!";
                                    Task.this.logFailed(reason);
                                    Task.this.clear();
                                }
                            } else {
                                Task.this.popupNext();
                                Task.this.logCompleted();
                                MenuPanel.getTheMenuPanel().setState(Task.this.getSuccessState());
                            }
                        }
                        if (!Task.this.success) {
                            Task.this.popupFailure(reason);
                        }
                        break block33;
                    }
                    catch (Exception e) {
                        reason = e.getMessage();
                        Task.this.logFailed(reason);
                        e.printStackTrace();
                        Object var5_5 = null;
                        Task.this.stillWorking = false;
                        MenuPanel.getTheMenuPanel().setCursor(new Cursor(preCursorType));
                        if (!Task.this.isModalTask()) break block33;
                        if (Task.this.success) {
                            if (Task.this.isCancelableTask()) {
                                if (Task.this.popupNextOrBack()) {
                                    Task.this.logCompleted();
                                    MenuPanel.getTheMenuPanel().setState(Task.this.getSuccessState());
                                } else {
                                    reason = "Taak geannuleerd!";
                                    Task.this.logFailed(reason);
                                    Task.this.clear();
                                }
                            } else {
                                Task.this.popupNext();
                                Task.this.logCompleted();
                                MenuPanel.getTheMenuPanel().setState(Task.this.getSuccessState());
                            }
                        }
                        if (!Task.this.success) {
                            Task.this.popupFailure(reason);
                        }
                        break block33;
                    }
                    Object var5_3 = null;
                    Task.this.stillWorking = false;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    Task.this.stillWorking = false;
                    MenuPanel.getTheMenuPanel().setCursor(new Cursor(preCursorType));
                    if (Task.this.isModalTask()) {
                        if (Task.this.success) {
                            if (Task.this.isCancelableTask()) {
                                if (Task.this.popupNextOrBack()) {
                                    Task.this.logCompleted();
                                    MenuPanel.getTheMenuPanel().setState(Task.this.getSuccessState());
                                } else {
                                    reason = "Taak geannuleerd!";
                                    Task.this.logFailed(reason);
                                    Task.this.clear();
                                }
                            } else {
                                Task.this.popupNext();
                                Task.this.logCompleted();
                                MenuPanel.getTheMenuPanel().setState(Task.this.getSuccessState());
                            }
                        }
                        if (!Task.this.success) {
                            Task.this.popupFailure(reason);
                        }
                    }
                    throw throwable;
                }
                MenuPanel.getTheMenuPanel().setCursor(new Cursor(preCursorType));
                if (Task.this.isModalTask()) {
                    if (Task.this.success) {
                        if (Task.this.isCancelableTask()) {
                            if (Task.this.popupNextOrBack()) {
                                Task.this.logCompleted();
                                MenuPanel.getTheMenuPanel().setState(Task.this.getSuccessState());
                            } else {
                                reason = "Taak geannuleerd!";
                                Task.this.logFailed(reason);
                                Task.this.clear();
                            }
                        } else {
                            Task.this.popupNext();
                            Task.this.logCompleted();
                            MenuPanel.getTheMenuPanel().setState(Task.this.getSuccessState());
                        }
                    }
                    if (!Task.this.success) {
                        Task.this.popupFailure(reason);
                    }
                }
            }
            System.gc();
            MenuPanel.getTheMenuPanel().setEnabled(true);
        }
    }

    class MonitoredThread
    extends Thread {
        MonitoredThread() {
        }

        public void run() {
            long initialTime = System.currentTimeMillis();
            Task.this.subTaskCount = 0;
            Task.this.monitor = new ProgressMonitor(MenuPanel.getTheMenuPanel(), Task.this.getTitle(), "", 0, Task.this.maxSubTasks);
            Task.this.monitor.setMillisToPopup(500);
            Task.this.monitor.setMillisToDecideToPopup(500);
            Task.this.stillWorking = true;
            new ActionThread().start();
            while (Task.this.stillWorking) {
                long currentTime = System.currentTimeMillis();
                long remainingTime = (currentTime - initialTime) * (long)(Task.this.maxSubTasks - Task.this.subTaskCount) / (long)(Task.this.subTaskCount + 1);
                Task.this.monitor.setNote(this.timeString(remainingTime));
                Task.this.monitor.setProgress(Task.this.subTaskCount);
                Task.this.stillWorking = Task.this.stillWorking & !Task.this.monitor.isCanceled();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {}
            }
            if (Task.this.monitor.isCanceled()) {
                Task.this.stopAction();
            }
            Task.this.monitor.close();
        }

        String timeString(long time_millis) {
            long time_hours = time_millis / 3600000L;
            long time_minutes = (time_millis %= 3600000L) / 60000L;
            long time_seconds = (time_millis %= 60000L) / 1000L;
            String result = "";
            result = result + Integer.toString((int)time_hours);
            result = result + ":";
            result = time_minutes < 10L ? result + "0" + time_minutes : result + time_minutes;
            result = result + ":";
            result = time_seconds < 10L ? result + "0" + time_seconds : result + time_seconds;
            return result;
        }
    }
}

