/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.Serializable;
import sos.koa.District;
import sos.koa.KiesLijst;

final class KiesKring
implements Comparable,
Serializable {
    static final byte KIESKRING_NUMBER_MAX_LENGTH = 2;
    static final byte KIESKRING_NAME_MAX_LENGTH = 80;
    static final int MAX_DISTRICTS_PER_KIESKRING = 100000;
    static final byte MAX_KIESLIJSTEN_PER_KIESKRING = 100;
    private static final KiesKring[] MY_CACHED_KIESKRINGEN = new KiesKring[101];
    final KiesLijst[] my_kiesLijsten = new KiesLijst[101];
    private byte my_number;
    private String my_name;
    private final District[] my_districts = new District[100001];
    private byte my_district_count;
    private byte my_kieslijst_count;

    private KiesKring(byte a_kieskring_number, String a_kieskring_name) {
        this.my_number = a_kieskring_number;
        this.my_name = a_kieskring_name;
    }

    static KiesKring make(byte a_kieskring_number, String a_kieskring_name) {
        KiesKring result;
        if (MY_CACHED_KIESKRINGEN[a_kieskring_number] != null && MY_CACHED_KIESKRINGEN[a_kieskring_number].name().equals(a_kieskring_name)) {
            return MY_CACHED_KIESKRINGEN[a_kieskring_number];
        }
        KiesKring.MY_CACHED_KIESKRINGEN[a_kieskring_number] = result = new KiesKring(a_kieskring_number, a_kieskring_name);
        return result;
    }

    byte number() {
        return this.my_number;
    }

    String name() {
        return this.my_name;
    }

    boolean addDistrict(District a_district) {
        if (this.hasDistrict(a_district)) {
            return false;
        }
        this.my_districts[a_district.number()] = a_district;
        this.my_district_count = (byte)(this.my_district_count + 1);
        return true;
    }

    District[] getDistricten() {
        return this.my_districts;
    }

    District getDistrict(byte a_district_number) {
        return this.my_districts[a_district_number];
    }

    boolean hasDistrict(District a_district) {
        return this.my_districts[a_district.number()] != null && this.my_districts[a_district.number()].equals(a_district);
    }

    byte districtCount() {
        return this.my_district_count;
    }

    boolean addKiesLijst(KiesLijst a_kieslijst) {
        if (this.hasKiesLijst(a_kieslijst)) {
            return false;
        }
        this.my_kiesLijsten[a_kieslijst.number()] = a_kieslijst;
        this.my_kieslijst_count = (byte)(this.my_kieslijst_count + 1);
        return true;
    }

    KiesLijst[] getKiesLijsten() {
        return this.my_kiesLijsten;
    }

    KiesLijst getKiesLijst(byte a_kieslijst_number) {
        return this.my_kiesLijsten[a_kieslijst_number];
    }

    boolean hasKiesLijst(KiesLijst a_kieslijst) {
        return this.my_kiesLijsten[a_kieslijst.number()] != null && this.my_kiesLijsten[a_kieslijst.number()].equals(a_kieslijst);
    }

    byte kieslijstCount() {
        return this.my_kieslijst_count;
    }

    void clear() {
        int i;
        this.my_number = 0;
        this.my_name = "";
        for (i = 0; i < this.my_districts.length; ++i) {
            if (this.my_districts[i] == null) continue;
            this.my_districts[i].clear();
            this.my_districts[i] = null;
        }
        this.my_district_count = 0;
        for (i = 0; i < this.my_kiesLijsten.length; ++i) {
            if (this.my_kiesLijsten[i] == null) continue;
            this.my_kiesLijsten[i].clear();
            this.my_kiesLijsten[i] = null;
        }
        this.my_kieslijst_count = 0;
        for (i = 0; i < MY_CACHED_KIESKRINGEN.length; ++i) {
            KiesKring.MY_CACHED_KIESKRINGEN[i] = null;
        }
    }

    public boolean equals(Object an_object) {
        if (an_object == null) {
            return false;
        }
        if (!(an_object instanceof KiesKring)) {
            return false;
        }
        KiesKring k = (KiesKring)an_object;
        return k.number() == this.number() && k.name().equals(this.name()) && k.my_districts.equals(this.my_districts);
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public String toString() {
        return this.number() + "." + (this.number() < 10 ? "  " : " ") + this.name();
    }

    public int compareTo(Object an_object) {
        if (!(an_object instanceof KiesKring)) {
            throw new ClassCastException();
        }
        KiesKring k = (KiesKring)an_object;
        return this.number() - k.number();
    }
}

