/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import sos.koa.AbstractObjectReader;
import sos.koa.AuditLog;
import sos.koa.Candidate;
import sos.koa.CandidateList;
import sos.koa.District;
import sos.koa.KiesKring;
import sos.koa.KiesLijst;
import sos.koa.MenuPanel;

public class CandidateListXMLReader
extends AbstractObjectReader {
    static final /* synthetic */ boolean $assertionsDisabled;

    public void parse(InputSource input) throws IOException, SAXException {
        this.parse(MenuPanel.getTheMenuPanel().getCandidateList());
    }

    public void parse(CandidateList candidates) throws SAXException {
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandler not set");
        }
        this.handler.startDocument();
        this.generateFor(candidates);
        this.handler.endDocument();
    }

    protected void generateFor(CandidateList candidates) throws SAXException {
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandler not set");
        }
        AttributesImpl atts = new AttributesImpl();
        String attName = "action";
        atts.addAttribute("", "", "action", "CDATA", "replace");
        attName = "contenttype";
        atts.addAttribute("", "", "contenttype", "CDATA", "kieslijst");
        this.handler.startElement("result", atts);
        this.handler.startElement("metadata");
        this.handler.startElement("requestreference");
        this.handler.endElement("requestreference");
        this.handler.startElement("responsereference");
        this.handler.endElement("responsereference");
        this.handler.startElement("creationtime");
        this.handler.endElement("creationtime");
        this.handler.startElement("kieskringcount");
        this.handler.endElement("kieskringcount");
        this.handler.startElement("districtcount");
        this.handler.endElement("districtcount");
        this.handler.startElement("kieslijstcount");
        this.handler.endElement("kieslijstcount");
        this.handler.startElement("positiecount");
        this.handler.endElement("positiecount");
        this.handler.endElement("metadata");
        atts = new AttributesImpl();
        attName = "stembureau";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getVotingBureau());
        attName = "voorzitter";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getVotingChairman());
        attName = "state";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getVotingState());
        attName = "verkiezing";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getVotingElection());
        attName = "periode";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getVotingInterval());
        attName = "stemming_start";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getVotingElectionTimestampStart());
        attName = "stemming_eind";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getVotingElectionTimestampEnd());
        attName = "kiesgerechtigden";
        atts.addAttribute("", attName, attName, "CDATA", Integer.toString(AuditLog.getVotingNrOfRegisteredVoters()));
        attName = "kiesgerechtigden_gestemd";
        atts.addAttribute("", attName, attName, "CDATA", Integer.toString(AuditLog.getImportVotesNrOfVotes()));
        attName = "kiesgerechtigden_niet_gestemd";
        atts.addAttribute("", attName, attName, "CDATA", Integer.toString(AuditLog.getVotingNrOfRegisteredVoters() - AuditLog.getImportVotesNrOfVotes()));
        this.handler.startElement("globaal", atts);
        this.handler.endElement("globaal");
        Set orderedKiesKringen = candidates.my_kieskringen.keySet();
        if (!$assertionsDisabled && orderedKiesKringen == null) {
            throw new AssertionError();
        }
        Iterator i = orderedKiesKringen.iterator();
        if (!$assertionsDisabled && i == null) {
            throw new AssertionError();
        }
        while (i.hasNext()) {
            int j;
            Byte b = (Byte)i.next();
            KiesKring kiesKring = (KiesKring)candidates.my_kieskringen.get(b);
            atts = new AttributesImpl();
            attName = "nummer";
            atts.addAttribute("", attName, attName, "CDATA", Byte.toString(kiesKring.number()));
            attName = "naam";
            atts.addAttribute("", attName, attName, "CDATA", kiesKring.name());
            this.handler.startElement("kieskring", atts);
            for (j = 0; j < kiesKring.getDistricten().length; ++j) {
                District district = kiesKring.getDistricten()[j];
                if (district == null) continue;
                atts = new AttributesImpl();
                attName = "nummer";
                atts.addAttribute("", attName, attName, "CDATA", Integer.toString(district.number()));
                attName = "naam";
                atts.addAttribute("", attName, attName, "CDATA", district.name());
                this.handler.startElement("district", atts);
                this.handler.endElement("district");
            }
            for (j = 0; j < kiesKring.getKiesLijsten().length; ++j) {
                KiesLijst kiesLijst = kiesKring.getKiesLijsten()[j];
                if (kiesLijst == null) continue;
                atts = new AttributesImpl();
                attName = "nummer";
                atts.addAttribute("", attName, attName, "CDATA", Short.toString(kiesLijst.number()));
                attName = "groepering";
                atts.addAttribute("", attName, attName, "CDATA", kiesLijst.name());
                attName = "stemmen";
                atts.addAttribute("", attName, attName, "CDATA", Integer.toString(kiesLijst.voteCount()));
                this.handler.startElement("kieslijst", atts);
                for (int k = 0; k < kiesLijst.my_candidates.length; ++k) {
                    Candidate candidate = kiesLijst.my_candidates[k];
                    if (candidate == null) continue;
                    atts = new AttributesImpl();
                    attName = "nummer";
                    atts.addAttribute("", attName, attName, "CDATA", Byte.toString(candidate.position_number()));
                    attName = "achternaam";
                    atts.addAttribute("", attName, attName, "CDATA", candidate.lastname());
                    attName = "voorletters";
                    atts.addAttribute("", attName, attName, "CDATA", candidate.initials());
                    attName = "roepnaam";
                    atts.addAttribute("", attName, attName, "CDATA", candidate.firstname());
                    attName = "geslacht";
                    atts.addAttribute("", attName, attName, "CDATA", Character.toString(candidate.gender()));
                    attName = "woonplaats";
                    atts.addAttribute("", attName, attName, "CDATA", candidate.cityOfResidence());
                    attName = "stemmen";
                    atts.addAttribute("", attName, attName, "CDATA", Integer.toString(candidate.voteCount()));
                    this.handler.startElement("positie", atts);
                    this.handler.endElement("positie");
                }
                this.handler.endElement("kieslijst");
            }
        }
        this.handler.endElement("kieskring");
        this.handler.endElement("result");
    }

    static {
        $assertionsDisabled = !CandidateListXMLReader.class.desiredAssertionStatus();
    }
}

