/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;
import sos.koa.AuditLog;
import sos.koa.AuditLogXMLReader;
import sos.koa.CandidateList;
import sos.koa.CandidateListXMLReader;
import sos.koa.KOAException;
import sos.koa.MenuPanel;
import sos.koa.Task;
import sos.koa.ViewPdf;

public class ReportAdapter
extends Task {
    String info;
    String votingInterval = "10 Mei 2004 9:00 - 10 Juni 2004 17:00";
    int registeredVoters = -1;

    String getTitle() {
        return "Rapporteren...";
    }

    String getSuccessMessage() {
        return "Rapporteren is gelukt!";
    }

    String getFailureMessage() {
        return "Rapporteren is mislukt!";
    }

    boolean isPreStateAllowed(int state) {
        return state == 7 || state == 8;
    }

    int getSuccessState() {
        return 8;
    }

    void doAction() throws KOAException {
        if (this.registeredVoters < 0) {
            this.registeredVoters = AuditLog.getImportVotesNrOfVotes();
        }
        this.info = "";
        AuditLog.setLogTimestamp();
        int selectedValue = JOptionPane.showOptionDialog(MenuPanel.getTheMenuPanel(), "Kies het rapporttype", "Rapporteren...", -1, 3, null, REPORT_OPTIONS, REPORT_OPTIONS[0]);
        switch (selectedValue) {
            case 1: {
                try {
                    this.votingInterval = JOptionPane.showInputDialog(MenuPanel.getTheMenuPanel(), "Geef de stemperiode", this.votingInterval);
                    if (this.votingInterval == null) {
                        throw new KOAException("Ongeldige stemperiode!");
                    }
                    AuditLog.setVotingInterval(this.votingInterval);
                    this.registeredVoters = Integer.parseInt(JOptionPane.showInputDialog(MenuPanel.getTheMenuPanel(), "Geef het aantal kiesgerechtigden", Integer.toString(this.registeredVoters)));
                    if (this.registeredVoters < 0) {
                        throw new KOAException("Aantal kiesgerechtigden negatief!");
                    }
                    if (this.registeredVoters < AuditLog.getImportVotesNrOfVotes()) {
                        throw new KOAException("Aantal kiesgerechtigden kleiner dan aantal stemmen!");
                    }
                    AuditLog.setVotingNrOfRegisteredVoters(this.registeredVoters);
                }
                catch (KOAException ke) {
                    this.votingInterval = "10 Mei 2004 9:00 - 10 Juni 2004 17:00";
                    this.registeredVoters = AuditLog.getImportVotesNrOfVotes();
                    throw new KOAException(ke.getMessage());
                }
                catch (NumberFormatException nfe) {
                    throw new KOAException("Ongeldige invoer!");
                }
                CandidateList candidates = MenuPanel.getTheMenuPanel().getCandidateList();
                try {
                    File baseDir = new File(".");
                    File outDir = new File(baseDir, "tmp");
                    outDir.mkdirs();
                    String recountXSL = this.getInputResource("xml/xslt/recount2pdf.xsl");
                    File xmlfile = new File(outDir, "telling.xml");
                    File pdffile = new File(outDir, "telling.pdf");
                    this.convertCandidateList2PDF(recountXSL, xmlfile, pdffile);
                    this.info = this.info + "Bekijk de file:\n\"" + pdffile.toString() + "\"";
                    ViewPdf.showPdf(pdffile);
                    break;
                }
                catch (IOException e) {
                    throw new KOAException("Probleem met IO");
                }
                catch (FOPException e) {
                    throw new KOAException("Probleem met FOP");
                }
                catch (TransformerException e) {
                    throw new KOAException("Probleem met de transformatie");
                }
                catch (Exception e) {
                    throw new KOAException("Onbekende fout");
                }
            }
            case 0: {
                try {
                    File baseDir = new File(".");
                    File outDir = new File(baseDir, "tmp");
                    outDir.mkdirs();
                    String auditlogXSL = this.getInputResource("xml/xslt/auditlog2pdf.xsl");
                    File xmlfile = new File(outDir, "verwerkingsverslag.xml");
                    File pdffile = new File(outDir, "verwerkingsverslag.pdf");
                    this.convertAuditLog2PDF(auditlogXSL, xmlfile, pdffile);
                    this.info = this.info + "Bekijk de file:\n\"" + pdffile.toString() + "\"";
                    ViewPdf.showPdf(pdffile);
                    break;
                }
                catch (IOException e) {
                    throw new KOAException("Probleem met IO");
                }
                catch (FOPException e) {
                    throw new KOAException("Probleem met FOP");
                }
                catch (TransformerException e) {
                    throw new KOAException("Probleem met de transformatie");
                }
                catch (Exception e) {
                    throw new KOAException("Onbekende fout");
                }
            }
            default: {
                throw new KOAException("Taak geannuleerd!");
            }
        }
    }

    void logStarted() {
    }

    void logCanceled() {
    }

    void logOpenedFile(File file) {
    }

    void logFailed(String reason) {
    }

    void logCompleted() {
    }

    String getInfo() {
        return this.info;
    }

    public void convertAuditLog2PDF(String xslt, File xmlOut, File pdfOut) throws IOException, FOPException, TransformerException {
        this.convertXML2PDF(new SAXSource(new AuditLogXMLReader(), new InputSource()), new StreamSource(xslt), new StreamResult(xmlOut), new FileOutputStream(pdfOut));
    }

    public void convertCandidateList2PDF(String xslt, File xmlOut, File pdfOut) throws IOException, FOPException, TransformerException {
        CandidateList candidates = MenuPanel.getTheMenuPanel().getCandidateList();
        this.convertXML2PDF(new SAXSource(new CandidateListXMLReader(), new InputSource()), new StreamSource(xslt), new StreamResult(xmlOut), new FileOutputStream(pdfOut));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertXML2PDF(Source src, StreamSource xslt, StreamResult xmlOut, OutputStream pdfOut) throws IOException, FOPException, TransformerException {
        Driver driver = new Driver();
        ConsoleLogger logger = new ConsoleLogger(5);
        driver.setLogger((Logger)logger);
        MessageHandler.setScreenLogger((Logger)logger);
        driver.setRenderer(1);
        try {
            driver.setOutputStream(pdfOut);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xslt);
            Transformer transformer1 = factory.newTransformer();
            transformer1.transform(src, xmlOut);
            SAXResult res = new SAXResult(driver.getContentHandler());
            transformer.transform(src, res);
        }
        finally {
            pdfOut.close();
        }
    }

    String getInputResource(String relPath) {
        Class<?> c = this.getClass();
        ClassLoader classLoader = null;
        URL absPath = null;
        if (c != null) {
            classLoader = c.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader != null) {
            absPath = ClassLoader.getSystemResource(relPath);
        }
        if (absPath == null) {
            absPath = c.getResource("../../" + relPath);
        }
        if (absPath != null) {
            return absPath.toString();
        }
        return relPath;
    }
}

