/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.svggen;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import java.util.Locale;

/**
 * Abstract class with common utility methods used by subclasses
 * for specific convertion operations. It holds a reference to a
 * domFactory Document, which many implementations use, and provides
 * a convenience method, to offers a convertion of double values
 * to String that remove the trailing '.' character on integral
 * values.
 *
 * @author <a href="mailto:vincent.hardy@eng.sun.com">Vincent Hardy</a>
 * @version $Id: AbstractSVGConverter.java,v 1.6 2003/07/04 15:25:37 vhardy Exp $
 */

public abstract class AbstractSVGConverter implements SVGConverter, ErrorConstants {
    /**
     * Used by converters to create Elements and other DOM objects
     */
    protected SVGGeneratorContext generatorContext;

    /**
     * Map of descriptions already processed by this converter. The
     * key type is left to the implementations
     */
    protected Map descMap = new HashMap();

    /**
     * Set of definitions to interpret the values of the attributes
     * generated by this converter since its creation
     */
    protected List defSet = new LinkedList();

    /**
     * @param genratorContext can be used by the SVGConverter extentions
     *        to create Elements and other types of DOM objects.
     */
    public AbstractSVGConverter(SVGGeneratorContext generatorContext) {
        if (generatorContext == null)
            throw new SVGGraphics2DRuntimeException(ERR_CONTEXT_NULL);

        this.generatorContext = generatorContext;
    }

    /**
     * @return set of definitions referenced by the attribute
     *         values created by the implementation since its
     *         creation. The return value should never be null.
     *         If no definition is needed, an empty set should be
     *         returned.
     */
    public List getDefinitionSet() {
        return defSet;
    }

    /**
     * Utility method for subclasses.
     */
    public final String doubleString(double value) {
        return generatorContext.doubleString(value);
    }
}
