/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.transcoder.keys;

import org.apache.batik.transcoder.TranscodingHints;
import org.w3c.dom.DOMImplementation;

/**
 * A transcoding Key represented as a DOMImplementation.
 *
 * @author <a href="mailto:Thierry.Kormann@sophia.inria.fr">Thierry Kormann</a>
 * @version $Id: DOMImplementationKey.java,v 1.1 2001/03/28 06:51:24 tkormann Exp $
 */
public class DOMImplementationKey extends TranscodingHints.Key {

    public boolean isCompatibleValue(Object v) {
        return (v instanceof DOMImplementation);
    }
}
