/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.parser;

/**
 * This interface must be implemented and then registred as the error handler
 * in order to be notified of parsing errors. 
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: ErrorHandler.java,v 1.1.1.1 2000/10/10 18:40:24 hillion Exp $
 */
public interface ErrorHandler {
    /**
     * Called when a parse error occurs.
     */
    void error(ParseException e) throws ParseException;
}
