/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.extensions.Destination;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.extensions.Outline;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.LinkedRectangle;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.pdf.CIDFont;
import org.apache.fop.render.pdf.Font;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.render.pdf.fonts.LazyFont;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.fop.svg.PDFTextPainter;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PDFRenderer
extends PrintRenderer {
    protected PDFDocument pdfDoc;
    protected PDFResources pdfResources;
    PDFStream currentStream;
    PDFAnnotList currentAnnotList;
    PDFPage currentPage;
    PDFColor currentColor;
    float currentLetterSpacing = Float.MAX_VALUE;
    boolean textOpen = false;
    int prevWordY = 0;
    int prevWordX = 0;
    int prevWordWidth = 0;
    private StringBuffer _wordAreaPDF = new StringBuffer();
    protected Map options;
    protected List extensions = null;

    public PDFRenderer() {
        this.pdfDoc = new PDFDocument();
    }

    public void setOptions(Map options) {
        this.options = options;
        boolean encrypt = false;
        String oPassword = "";
        String uPassword = "";
        boolean allowPrint = true;
        boolean allowCopyContent = true;
        boolean allowEditContent = true;
        boolean allowEditAnnotations = true;
        String option = (String)options.get("ownerPassword");
        if (option != null) {
            encrypt = true;
            oPassword = option;
        }
        if ((option = (String)options.get("userPassword")) != null) {
            encrypt = true;
            uPassword = option;
        }
        if ((option = (String)options.get("allowPrint")) != null) {
            encrypt = true;
            allowPrint = option.equals("TRUE");
        }
        if ((option = (String)options.get("allowCopyContent")) != null) {
            encrypt = true;
            allowCopyContent = option.equals("TRUE");
        }
        if ((option = (String)options.get("allowEditContent")) != null) {
            encrypt = true;
            allowEditContent = option.equals("TRUE");
        }
        if ((option = (String)options.get("allowEditAnnotations")) != null) {
            encrypt = true;
            allowEditAnnotations = option.equals("TRUE");
        }
        if (encrypt) {
            this.pdfDoc.setEncryption(oPassword, uPassword, allowPrint, allowCopyContent, allowEditContent, allowEditAnnotations);
        }
    }

    public void setProducer(String producer) {
        this.pdfDoc.setProducer(producer);
    }

    public void startRenderer(OutputStream stream) throws IOException {
        this.pdfDoc.outputHeader(stream);
    }

    public void stopRenderer(OutputStream stream) throws IOException {
        this.renderRootExtensions(this.extensions);
        FontSetup.addToResources(this.pdfDoc, this.fontInfo);
        this.pdfDoc.outputTrailer(stream);
        this.pdfDoc = new PDFDocument();
        this.pdfResources = null;
        this.extensions = null;
        this.currentStream = null;
        this.currentAnnotList = null;
        this.currentPage = null;
        this.currentColor = null;
        super.stopRenderer(stream);
    }

    protected void addLine(int x1, int y1, int x2, int y2, int th, PDFPathPaint stroke) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + stroke.getColorSpaceOut(false) + (float)x1 / 1000.0f + " " + (float)y1 / 1000.0f + " m " + (float)x2 / 1000.0f + " " + (float)y2 / 1000.0f + " l " + (float)th / 1000.0f + " w S\n" + "Q\nBT\n");
    }

    protected void addLine(int x1, int y1, int x2, int y2, int th, int rs, PDFPathPaint stroke) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + stroke.getColorSpaceOut(false) + this.setRuleStylePattern(rs) + (float)x1 / 1000.0f + " " + (float)y1 / 1000.0f + " m " + (float)x2 / 1000.0f + " " + (float)y2 / 1000.0f + " l " + (float)th / 1000.0f + " w S\n" + "Q\nBT\n");
    }

    protected void addRect(int x, int y, int w, int h, PDFPathPaint stroke) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + stroke.getColorSpaceOut(false) + (float)x / 1000.0f + " " + (float)y / 1000.0f + " " + (float)w / 1000.0f + " " + (float)h / 1000.0f + " re s\n" + "Q\nBT\n");
    }

    protected void addRect(int x, int y, int w, int h, PDFPathPaint stroke, PDFPathPaint fill) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + fill.getColorSpaceOut(true) + stroke.getColorSpaceOut(false) + (float)x / 1000.0f + " " + (float)y / 1000.0f + " " + (float)w / 1000.0f + " " + (float)h / 1000.0f + " re b\n" + "Q\nBT\n");
    }

    protected void addFilledRect(int x, int y, int w, int h, PDFPathPaint fill) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + fill.getColorSpaceOut(true) + (float)x / 1000.0f + " " + (float)y / 1000.0f + " " + (float)w / 1000.0f + " " + (float)h / 1000.0f + " re f\n" + "Q\nBT\n");
    }

    protected void drawImageScaled(int x, int y, int w, int h, FopImage image, FontState fs) {
        if (image instanceof SVGImage) {
            try {
                this.closeText();
                SVGDocument svg = ((SVGImage)image).getSVGDocument();
                this.currentStream.add("ET\nq\n");
                this.renderSVGDocument(svg, x, y, fs);
                this.currentStream.add("Q\nBT\n");
            }
            catch (FopImageException e) {}
        } else {
            int xObjectNum = this.pdfDoc.addImage(image);
            this.closeText();
            this.currentStream.add("ET\nq\n" + (float)w / 1000.0f + " 0 0 " + (float)h / 1000.0f + " " + (float)x / 1000.0f + " " + ((float)y - (float)h) / 1000.0f + " cm\n" + "/Im" + xObjectNum + " Do\nQ\nBT\n");
        }
    }

    protected void drawImageClipped(int x, int y, int clipX, int clipY, int clipW, int clipH, FopImage image, FontState fs) {
        int imgH;
        int imgW;
        float cx1 = (float)x / 1000.0f;
        float cy1 = ((float)y - (float)clipH) / 1000.0f;
        float cx2 = ((float)x + (float)clipW) / 1000.0f;
        float cy2 = (float)y / 1000.0f;
        int imgX = x - clipX;
        int imgY = y - clipY;
        try {
            imgW = image.getWidth() * 1000;
            imgH = image.getHeight() * 1000;
        }
        catch (FopImageException fie) {
            this.log.error("Error obtaining image width and height", (Throwable)fie);
            return;
        }
        if (image instanceof SVGImage) {
            try {
                this.closeText();
                SVGDocument svg = ((SVGImage)image).getSVGDocument();
                this.currentStream.add("ET\nq\n" + cx1 + " " + cy1 + " m\n" + cx2 + " " + cy1 + " l\n" + cx2 + " " + cy2 + " l\n" + cx1 + " " + cy2 + " l\n" + "W\n" + "n\n");
                this.renderSVGDocument(svg, imgX, imgY, fs);
                this.currentStream.add("Q\nBT\n");
            }
            catch (FopImageException e) {}
        } else {
            int xObjectNum = this.pdfDoc.addImage(image);
            this.closeText();
            this.currentStream.add("ET\nq\n" + cx1 + " " + cy1 + " m\n" + cx2 + " " + cy1 + " l\n" + cx2 + " " + cy2 + " l\n" + cx1 + " " + cy2 + " l\n" + "W\n" + "n\n" + (float)imgW / 1000.0f + " 0 0 " + (float)imgH / 1000.0f + " " + (float)imgX / 1000.0f + " " + ((float)imgY - (float)imgH) / 1000.0f + " cm\n" + "s\n" + "/Im" + xObjectNum + " Do\nQ\nBT\n");
        }
    }

    public void renderForeignObjectArea(ForeignObjectArea area) {
        this.currentXPosition += area.getXOffset();
        this.currentYPosition = this.currentYPosition;
        switch (area.getAlign()) {
            case 106: {
                break;
            }
            case 30: {
                break;
            }
        }
        switch (area.getVerticalAlign()) {
            case 9: {
                break;
            }
            case 65: {
                break;
            }
            case 108: {
                break;
            }
            case 109: {
                break;
            }
            case 115: {
                break;
            }
            case 114: {
                break;
            }
            case 116: {
                break;
            }
        }
        this.closeText();
        this.currentStream.add("ET\n");
        this.currentStream.add("q\n");
        switch (area.scalingMethod()) {
            case 122: {
                break;
            }
        }
        switch (area.getOverflow()) {
            case 8: 
            case 101: 
            case 125: {
                break;
            }
        }
        area.getObject().render(this);
        this.currentStream.add("Q\n");
        this.currentStream.add("BT\n");
        this.currentXPosition += area.getEffectiveWidth();
    }

    public void renderSVGArea(SVGArea area) {
        int x = this.currentXPosition;
        int y = this.currentYPosition;
        this.renderSVGDocument(area.getSVGDocument(), x, y, area.getFontState());
    }

    protected void renderSVGDocument(Document doc, int x, int y, FontState fs) {
        GraphicsNode root;
        float sx = 1.0f;
        float sy = -1.0f;
        int xOffset = x;
        int yOffset = y;
        SVGUserAgent userAgent = new SVGUserAgent(new AffineTransform());
        userAgent.setLogger(this.log);
        GVTBuilder builder = new GVTBuilder();
        BridgeContext ctx = new BridgeContext(userAgent);
        TextPainter textPainter = null;
        Boolean bl = Configuration.getBooleanValue("strokeSVGText");
        textPainter = bl == null || bl != false ? new StrokingTextPainter() : new PDFTextPainter(fs);
        ctx.setTextPainter(textPainter);
        PDFAElementBridge aBridge = new PDFAElementBridge();
        aBridge.setCurrentTransform(new AffineTransform(sx, 0.0f, 0.0f, sy, (float)xOffset / 1000.0f, (float)yOffset / 1000.0f));
        ctx.putBridge(aBridge);
        try {
            root = builder.build(ctx, doc);
        }
        catch (Exception e) {
            this.log.error("svg graphic could not be built: " + e.getMessage(), (Throwable)e);
            return;
        }
        float w = (float)ctx.getDocumentSize().getWidth() * 1000.0f;
        float h = (float)ctx.getDocumentSize().getHeight() * 1000.0f;
        ctx = null;
        builder = null;
        this.currentStream.add("q\n");
        if (w != 0.0f && h != 0.0f) {
            this.currentStream.add((float)x / 1000.0f + " " + (float)y / 1000.0f + " m\n");
            this.currentStream.add(((float)x + w) / 1000.0f + " " + (float)y / 1000.0f + " l\n");
            this.currentStream.add(((float)x + w) / 1000.0f + " " + ((float)y - h) / 1000.0f + " l\n");
            this.currentStream.add((float)x / 1000.0f + " " + ((float)y - h) / 1000.0f + " l\n");
            this.currentStream.add("h\n");
            this.currentStream.add("W\n");
            this.currentStream.add("n\n");
        }
        this.currentStream.add(sx + " 0 0 " + sy + " " + (float)xOffset / 1000.0f + " " + (float)yOffset / 1000.0f + " cm\n");
        SVGSVGElement svg = ((SVGDocument)doc).getRootElement();
        AffineTransform at = ViewBox.getPreserveAspectRatioTransform(svg, w / 1000.0f, h / 1000.0f);
        if (!at.isIdentity()) {
            double[] vals = new double[6];
            at.getMatrix(vals);
            this.currentStream.add(PDFNumber.doubleOut(vals[0], 8) + " " + PDFNumber.doubleOut(vals[1], 8) + " " + PDFNumber.doubleOut(vals[2], 8) + " " + PDFNumber.doubleOut(vals[3], 8) + " " + PDFNumber.doubleOut(vals[4], 8) + " " + PDFNumber.doubleOut(vals[5], 8) + " cm\n");
        }
        PDFGraphics2D graphics = new PDFGraphics2D(true, fs, this.pdfDoc, this.currentFontName, this.currentFontSize, this.currentXPosition, this.currentYPosition);
        graphics.setGraphicContext(new GraphicContext());
        try {
            root.paint(graphics);
            this.currentStream.add(graphics.getString());
        }
        catch (Exception e) {
            this.log.error("svg graphic could not be rendered: " + e.getMessage(), (Throwable)e);
        }
        this.currentAnnotList = graphics.getAnnotList();
        this.currentStream.add("Q\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderWordArea(WordArea area) {
        StringBuffer stringBuffer = this._wordAreaPDF;
        synchronized (stringBuffer) {
            float letterspacing;
            String endText;
            StringBuffer pdf = this._wordAreaPDF;
            pdf.setLength(0);
            Map kerning = null;
            boolean kerningAvailable = false;
            kerning = area.getFontState().getKerning();
            if (kerning != null && !kerning.isEmpty()) {
                kerningAvailable = true;
            }
            String name = area.getFontState().getFontName();
            int size = area.getFontState().getFontSize();
            boolean useMultiByte = false;
            Font f = (Font)area.getFontState().getFontInfo().getFonts().get(name);
            if (f instanceof LazyFont) {
                if (((LazyFont)f).getRealFont() instanceof CIDFont) {
                    useMultiByte = true;
                }
            } else if (f instanceof CIDFont) {
                useMultiByte = true;
            }
            String startText = useMultiByte ? "<" : "(";
            String string = endText = useMultiByte ? "> " : ") ";
            if (!name.equals(this.currentFontName) || size != this.currentFontSize) {
                this.closeText();
                this.currentFontName = name;
                this.currentFontSize = size;
                pdf = pdf.append("/" + name + " " + (float)size / 1000.0f + " Tf\n");
            }
            if ((letterspacing = (float)area.getFontState().getLetterSpacing() / 1000.0f) != this.currentLetterSpacing) {
                this.currentLetterSpacing = letterspacing;
                this.closeText();
                pdf.append(letterspacing).append(" Tc\n");
            }
            PDFColor areaColor = null;
            if (this.currentFill instanceof PDFColor) {
                areaColor = (PDFColor)this.currentFill;
            }
            if (areaColor == null || areaColor.red() != (double)area.getRed() || areaColor.green() != (double)area.getGreen() || areaColor.blue() != (double)area.getBlue()) {
                areaColor = new PDFColor(area.getRed(), area.getGreen(), area.getBlue());
                this.closeText();
                this.currentFill = areaColor;
                pdf.append(this.currentFill.getColorSpaceOut(true));
            }
            int rx = this.currentXPosition;
            int bl = this.currentYPosition;
            this.addWordLines(area, rx, bl, size, areaColor);
            if (!this.textOpen || bl != this.prevWordY) {
                this.closeText();
                pdf.append("1 0 0 1 " + (float)rx / 1000.0f + " " + (float)bl / 1000.0f + " Tm [" + startText);
                this.prevWordY = bl;
                this.textOpen = true;
            } else {
                int space = this.prevWordX - rx + this.prevWordWidth;
                float emDiff = (float)space / (float)this.currentFontSize * 1000.0f;
                if (emDiff < -33000.0f) {
                    this.closeText();
                    pdf.append("1 0 0 1 " + (float)rx / 1000.0f + " " + (float)bl / 1000.0f + " Tm [" + startText);
                    this.textOpen = true;
                } else {
                    pdf.append(Float.toString(emDiff));
                    pdf.append(" ");
                    pdf.append(startText);
                }
            }
            this.prevWordWidth = area.getContentWidth();
            this.prevWordX = rx;
            String s = area.getText();
            int l = s.length();
            for (int i = 0; i < l; ++i) {
                char ch = area.getFontState().mapChar(s.charAt(i));
                if (!useMultiByte) {
                    if (ch > '\u007f') {
                        pdf.append("\\");
                        pdf.append(Integer.toOctalString(ch));
                    } else {
                        switch (ch) {
                            case '(': 
                            case ')': 
                            case '\\': {
                                pdf.append("\\");
                            }
                        }
                        pdf.append(ch);
                    }
                } else {
                    pdf.append(this.getUnicodeString(ch));
                }
                if (!kerningAvailable || i + 1 >= l) continue;
                this.addKerning(pdf, new Integer(ch), new Integer(area.getFontState().mapChar(s.charAt(i + 1))), kerning, startText, endText);
            }
            pdf.append(endText);
            this.currentStream.add(pdf.toString());
            this.currentXPosition += area.getContentWidth();
        }
    }

    private String getUnicodeString(char c) {
        StringBuffer buf = new StringBuffer(4);
        byte[] uniBytes = null;
        try {
            char[] a = new char[]{c};
            uniBytes = new String(a).getBytes("UnicodeBigUnmarked");
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Incompatible VM", (Throwable)e);
        }
        for (int i = 0; i < uniBytes.length; ++i) {
            int b = uniBytes[i] < 0 ? 256 + uniBytes[i] : uniBytes[i];
            String hexString = Integer.toHexString(b);
            buf = hexString.length() == 1 ? buf.append("0" + hexString) : buf.append(hexString);
        }
        return buf.toString();
    }

    private void closeText() {
        if (this.textOpen) {
            this.currentStream.add("] TJ\n");
            this.textOpen = false;
            this.prevWordX = 0;
            this.prevWordY = 0;
        }
    }

    private void addKerning(StringBuffer buf, Integer ch1, Integer ch2, Map kerning, String startText, String endText) {
        Integer width;
        Map kernPair = (Map)kerning.get(ch1);
        if (kernPair != null && (width = (Integer)kernPair.get(ch2)) != null) {
            buf.append(endText).append(-width.intValue()).append(' ').append(startText);
        }
    }

    public void render(Page page, OutputStream outputStream) throws FOPException, IOException {
        this.idReferences = page.getIDReferences();
        this.pdfResources = this.pdfDoc.getResources();
        this.pdfDoc.setIDReferences(this.idReferences);
        this.renderPage(page);
        ArrayList exts = page.getExtensions();
        if (exts != null) {
            this.extensions = exts;
        }
        this.pdfDoc.output(outputStream);
    }

    public void renderPage(Page page) {
        this.currentStream = this.pdfDoc.makeStream();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.currentStream.add("BT\n");
        this.renderRegions(page);
        this.closeText();
        float w = page.getWidth();
        float h = page.getHeight();
        this.currentStream.add("ET\n");
        this.currentPage = this.pdfDoc.makePage(this.pdfResources, this.currentStream, Math.round(w / 1000.0f), Math.round(h / 1000.0f), page);
        if (page.hasLinks() || this.currentAnnotList != null) {
            if (this.currentAnnotList == null) {
                this.currentAnnotList = this.pdfDoc.makeAnnotList();
            }
            this.currentPage.setAnnotList(this.currentAnnotList);
            ArrayList linkSets = page.getLinkSets();
            for (int i = 0; i < linkSets.size(); ++i) {
                LinkSet linkSet = (LinkSet)linkSets.get(i);
                linkSet.align();
                String dest = linkSet.getDest();
                int linkType = linkSet.getLinkType();
                List linkRects = linkSet.getRects();
                for (int j = 0; j < linkRects.size(); ++j) {
                    LinkedRectangle lrect = (LinkedRectangle)linkRects.get(j);
                    this.currentAnnotList.addLink(this.pdfDoc.makeLink(lrect.getRectangle(), dest, linkType));
                }
            }
            this.currentAnnotList = null;
        } else {
            this.currentAnnotList = null;
        }
        this.currentFill = null;
    }

    private String setRuleStylePattern(int style) {
        String rs = "";
        switch (style) {
            case 104: {
                rs = "[] 0 d ";
                break;
            }
            case 22: {
                rs = "[3 3] 0 d ";
                break;
            }
            case 27: {
                rs = "[1 3] 0 d ";
                break;
            }
            case 28: {
                rs = "[] 0 d ";
                break;
            }
            default: {
                rs = "[] 0 d ";
            }
        }
        return rs;
    }

    protected void renderRootExtensions(List extensions) {
        if (extensions != null) {
            for (int i = 0; i < extensions.size(); ++i) {
                ExtensionObj ext = (ExtensionObj)extensions.get(i);
                if (ext instanceof Outline) {
                    this.renderOutline((Outline)ext);
                    continue;
                }
                if (!(ext instanceof Destination)) continue;
                Destination d = (Destination)ext;
                this.pdfDoc.addDestination(d.getDestinationName(), d.getInternalDestination());
            }
        }
    }

    private void renderOutline(Outline outline) {
        PDFOutline outlineRoot = this.pdfDoc.getOutlineRoot();
        PDFOutline pdfOutline = null;
        Outline parent = outline.getParentOutline();
        if (parent == null) {
            pdfOutline = this.pdfDoc.makeOutline(outlineRoot, outline.getLabel().toString(), outline.getInternalDestination());
        } else {
            PDFOutline pdfParentOutline = (PDFOutline)parent.getRendererObject();
            if (pdfParentOutline == null) {
                this.log.error("pdfParentOutline is null");
            } else {
                pdfOutline = this.pdfDoc.makeOutline(pdfParentOutline, outline.getLabel().toString(), outline.getInternalDestination());
            }
        }
        outline.setRendererObject(pdfOutline);
        ArrayList v = outline.getOutlines();
        for (int i = 0; i < v.size(); ++i) {
            this.renderOutline((Outline)v.get(i));
        }
    }
}

