/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.ASCII85Filter;
import org.apache.fop.pdf.ASCIIHexFilter;
import org.apache.fop.pdf.FlateFilter;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFObject;

public class PDFStream
extends PDFObject {
    protected ByteArrayOutputStream _data = new ByteArrayOutputStream();
    private List _filters = new ArrayList();

    public PDFStream(int number) {
        super(number);
    }

    public void add(String s) {
        try {
            try {
                this._data.write(s.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException ue) {
                this._data.write(s.getBytes());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void addFilter(PDFFilter filter) {
        if (filter != null) {
            this._filters.add(filter);
        }
    }

    public void addFilter(String filterType) {
        if (filterType == null) {
            return;
        }
        if (filterType.equals("flate")) {
            this.addFilter(new FlateFilter());
        } else if (filterType.equals("ascii-85")) {
            this.addFilter(new ASCII85Filter());
        } else if (filterType.equals("ascii-hex")) {
            this.addFilter(new ASCIIHexFilter());
        } else {
            if (filterType.equals("")) {
                return;
            }
            MessageHandler.errorln("Unsupported filter type in stream-filter-list: " + filterType);
        }
    }

    protected void addDefaultFilters() {
        List filters = Configuration.getListValue("stream-filter-list", 1);
        if (filters == null) {
            String filter = Configuration.getStringValue("stream-filter-list", 1);
            if (filter == null) {
                this.addFilter(new FlateFilter());
            } else {
                this.addFilter(filter);
            }
        } else {
            for (int i = 0; i < filters.size(); ++i) {
                String v = (String)filters.get(i);
                this.addFilter(v);
            }
        }
    }

    public void addImageArray(int[] pixels, int width, int height) {
        try {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int p = pixels[i * width + j];
                    int r = p >> 16 & 0xFF;
                    int g = p >> 8 & 0xFF;
                    int b = p & 0xFF;
                    if (r < 16) {
                        this._data.write(48);
                    }
                    try {
                        this._data.write(Integer.toHexString(r).getBytes("ISO-8859-1"));
                    }
                    catch (UnsupportedEncodingException ue) {
                        this._data.write(Integer.toHexString(r).getBytes());
                    }
                    if (g < 16) {
                        this._data.write(48);
                    }
                    try {
                        this._data.write(Integer.toHexString(g).getBytes("ISO-8859-1"));
                    }
                    catch (UnsupportedEncodingException ue) {
                        this._data.write(Integer.toHexString(g).getBytes());
                    }
                    if (b < 16) {
                        this._data.write(48);
                    }
                    try {
                        this._data.write(Integer.toHexString(b).getBytes("ISO-8859-1"));
                    }
                    catch (UnsupportedEncodingException ue) {
                        this._data.write(Integer.toHexString(b).getBytes());
                    }
                    this._data.write(32);
                }
            }
            try {
                this._data.write(">\n".getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException ue) {
                this._data.write(">\n".getBytes());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setData(byte[] data) throws IOException {
        this._data.reset();
        this._data.write(data);
    }

    public byte[] getData() {
        return this._data.toByteArray();
    }

    public int getDataLength() {
        return this._data.size();
    }

    public byte[] toPDF() {
        throw new RuntimeException();
    }

    protected int output(OutputStream stream) throws IOException {
        byte[] p;
        int length = 0;
        String filterEntry = this.applyFilters();
        String s = this.number + " " + this.generation + " obj\n<< /Length " + (this._data.size() + 1) + " " + filterEntry + " >>\n";
        try {
            p = s.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            p = s.getBytes();
        }
        stream.write(p);
        length += p.length;
        length += this.outputStreamData(stream);
        try {
            p = "endobj\n".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            p = "endobj\n".getBytes();
        }
        stream.write(p);
        return length += p.length;
    }

    protected int outputStreamData(OutputStream stream) throws IOException {
        byte[] p;
        int length = 0;
        try {
            p = "stream\n".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            p = "stream\n".getBytes();
        }
        stream.write(p);
        length += p.length;
        this._data.writeTo(stream);
        length += this._data.size();
        try {
            p = "\nendstream\n".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            p = "\nendstream\n".getBytes();
        }
        stream.write(p);
        return length += p.length;
    }

    protected String applyFilters() throws IOException {
        if (this._filters.size() > 0) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> parms = new ArrayList<String>();
            for (int i = 0; i < this._filters.size(); ++i) {
                PDFFilter filter = (PDFFilter)this._filters.get(i);
                if (!filter.isApplied()) {
                    byte[] tmp = filter.encode(this._data.toByteArray());
                    this._data.reset();
                    this._data.write(tmp);
                    filter.setApplied(true);
                }
                names.add(0, filter.getName());
                parms.add(0, filter.getDecodeParms());
            }
            return this.buildFilterEntries(names) + this.buildDecodeParms(parms);
        }
        return "";
    }

    private String buildFilterEntries(List names) {
        StringBuffer sb = new StringBuffer();
        sb.append("/Filter ");
        if (names.size() > 1) {
            sb.append("[ ");
        }
        for (int i = 0; i < names.size(); ++i) {
            sb.append((String)names.get(i));
            sb.append(" ");
        }
        if (names.size() > 1) {
            sb.append("]");
        }
        sb.append("\n");
        return sb.toString();
    }

    private String buildDecodeParms(List parms) {
        StringBuffer sb = new StringBuffer();
        boolean needParmsEntry = false;
        sb.append("/DecodeParms ");
        if (parms.size() > 1) {
            sb.append("[ ");
        }
        for (int i = 0; i < parms.size(); ++i) {
            String s = (String)parms.get(i);
            if (s != null) {
                sb.append(s);
                needParmsEntry = true;
            } else {
                sb.append("null");
            }
            sb.append(" ");
        }
        if (parms.size() > 1) {
            sb.append("]");
        }
        sb.append("\n");
        if (needParmsEntry) {
            return sb.toString();
        }
        return "";
    }
}

