/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.FileOutputStream;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Starter;
import org.apache.fop.apps.Version;
import org.apache.fop.configuration.Configuration;
import org.xml.sax.XMLReader;

public class CommandLineStarter
extends Starter {
    CommandLineOptions commandLineOptions;
    boolean errorDump;

    public CommandLineStarter(CommandLineOptions commandLineOptions) throws FOPException {
        this.commandLineOptions = commandLineOptions;
        this.options.setCommandLineOptions(commandLineOptions);
        this.errorDump = Configuration.getBooleanValue("debugMode");
        super.setInputHandler(commandLineOptions.getInputHandler());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws FOPException {
        String version = Version.getVersion();
        this.log.info(version);
        XMLReader parser = this.inputHandler.getParser();
        Driver driver = new Driver();
        driver.setLogger(this.log);
        if (this.errorDump) {
            driver.setErrorDump(true);
        }
        FileOutputStream output = null;
        try {
            try {
                output = new FileOutputStream(this.commandLineOptions.getOutputFile());
                driver.setRenderer(this.commandLineOptions.getRenderer());
                driver.setOutputStream(output);
                driver.getRenderer().setOptions(this.commandLineOptions.getRendererOptions());
                driver.render(parser, this.inputHandler.getInputSource());
            }
            catch (Exception e) {
                if (!(e instanceof FOPException)) throw new FOPException(e);
                throw (FOPException)e;
            }
            Object var7_5 = null;
            if (output == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (output == null) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        output.close();
        return;
    }
}

