/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import sos.koa.AbstractObjectReader;
import sos.koa.AuditLog;

public class AuditLogXMLReader
extends AbstractObjectReader {
    public void parse(InputSource input) throws IOException, SAXException, IllegalStateException {
        this.parse();
    }

    public void parse() throws SAXException, IllegalStateException {
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandler not set");
        }
        this.handler.startDocument();
        this.generateFor();
        this.handler.endDocument();
    }

    protected void generateFor() throws SAXException, IllegalStateException {
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandler not set");
        }
        AttributesImpl atts = new AttributesImpl();
        String attName = "timestamp";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getLogTimestamp());
        this.handler.startElement("log", atts);
        atts = new AttributesImpl();
        attName = "success";
        if (AuditLog.getImportCandidatesSuccess()) {
            atts.addAttribute("", attName, attName, "CDATA", "yes");
            this.handler.startElement("importcandidates", atts);
        } else {
            atts.addAttribute("", attName, attName, "CDATA", "no");
            this.handler.startElement("importcandidates", atts);
            this.handler.element("error", AuditLog.getImportCandidatesError());
        }
        atts = new AttributesImpl();
        attName = "location";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getImportCandidatesFileName());
        attName = "timestamp";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getImportCandidatesFileTimestamp());
        this.handler.startElement("file", atts);
        this.handler.endElement("file");
        atts = new AttributesImpl();
        attName = "refnr";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getImportCandidatesRefNr());
        attName = "nroflists";
        atts.addAttribute("", attName, attName, "CDATA", Integer.toString(AuditLog.getImportCandidatesNrOfLists()));
        attName = "nrofcandidates";
        atts.addAttribute("", attName, attName, "CDATA", Integer.toString(AuditLog.getImportCandidatesNrOfCandidates()));
        attName = "nrofblanco";
        atts.addAttribute("", attName, attName, "CDATA", Integer.toString(AuditLog.getImportCandidatesNrOfBlanco()));
        this.handler.startElement("candidatecontents", atts);
        this.handler.endElement("candidatecontents");
        this.handler.endElement("importcandidates");
        atts = new AttributesImpl();
        attName = "success";
        if (AuditLog.getImportVotesSuccess()) {
            atts.addAttribute("", attName, attName, "CDATA", "yes");
            this.handler.startElement("importvotes", atts);
        } else {
            atts.addAttribute("", attName, attName, "CDATA", "no");
            this.handler.startElement("importvotes", atts);
            this.handler.element("error", AuditLog.getImportVotesError());
        }
        atts = new AttributesImpl();
        attName = "location";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getImportVotesFileName());
        attName = "timestamp";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getImportVotesFileTimestamp());
        this.handler.startElement("file", atts);
        this.handler.endElement("file");
        atts = new AttributesImpl();
        attName = "nrofkieskringen";
        atts.addAttribute("", attName, attName, "CDATA", Integer.toString(AuditLog.getImportVotesNrOfKieskringen()));
        attName = "nrofvotes";
        atts.addAttribute("", attName, attName, "CDATA", Integer.toString(AuditLog.getImportVotesNrOfVotes()));
        this.handler.startElement("votecontents", atts);
        this.handler.endElement("votecontents");
        this.handler.endElement("importvotes");
        atts = new AttributesImpl();
        attName = "success";
        if (AuditLog.getImportPrivKeySuccess()) {
            atts.addAttribute("", attName, attName, "CDATA", "yes");
            this.handler.startElement("importprivkey", atts);
        } else {
            atts.addAttribute("", attName, attName, "CDATA", "no");
            this.handler.startElement("importprivkey", atts);
            this.handler.element("error", AuditLog.getImportPrivKeyError());
        }
        atts = new AttributesImpl();
        attName = "location";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getImportPrivKeyFileName());
        attName = "timestamp";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getImportPrivKeyFileTimestamp());
        this.handler.startElement("file", atts);
        this.handler.endElement("file");
        this.handler.endElement("importprivkey");
        atts = new AttributesImpl();
        attName = "success";
        if (AuditLog.getImportPubKeySuccess()) {
            atts.addAttribute("", attName, attName, "CDATA", "yes");
            this.handler.startElement("importpubkey", atts);
        } else {
            atts.addAttribute("", attName, attName, "CDATA", "no");
            this.handler.startElement("importpubkey", atts);
            this.handler.element("error", AuditLog.getImportPubKeyError());
        }
        atts = new AttributesImpl();
        attName = "location";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getImportPubKeyFileName());
        attName = "timestamp";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getImportPubKeyFileTimestamp());
        this.handler.startElement("file", atts);
        this.handler.endElement("file");
        this.handler.endElement("importpubkey");
        atts = new AttributesImpl();
        attName = "success";
        if (AuditLog.getKeypairSuccess()) {
            atts.addAttribute("", attName, attName, "CDATA", "yes");
            this.handler.startElement("keypair", atts);
        } else {
            atts.addAttribute("", attName, attName, "CDATA", "no");
            this.handler.startElement("keypair", atts);
        }
        this.handler.endElement("keypair");
        atts = new AttributesImpl();
        attName = "success";
        String[] decryptErrors = AuditLog.getDecryptErrors();
        if (AuditLog.getDecryptSuccess() && decryptErrors.length == 0) {
            atts.addAttribute("", attName, attName, "CDATA", "yes");
        } else {
            atts.addAttribute("", attName, attName, "CDATA", "no");
        }
        this.handler.startElement("decrypt", atts);
        for (int i = 0; i < decryptErrors.length; ++i) {
            this.handler.element("error", decryptErrors[i]);
        }
        atts = new AttributesImpl();
        attName = "start";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getDecryptTimestampStart());
        attName = "end";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getDecryptTimestampEnd());
        this.handler.startElement("runtime", atts);
        this.handler.endElement("runtime");
        atts = new AttributesImpl();
        attName = "nrofvotes";
        atts.addAttribute("", attName, attName, "CDATA", Integer.toString(AuditLog.getDecryptNrOfVotes()));
        this.handler.startElement("result", atts);
        this.handler.endElement("result");
        this.handler.endElement("decrypt");
        atts = new AttributesImpl();
        attName = "success";
        String[] countErrors = AuditLog.getCountErrors();
        if (AuditLog.getCountSuccess() && countErrors.length == 0) {
            atts.addAttribute("", attName, attName, "CDATA", "yes");
        } else {
            atts.addAttribute("", attName, attName, "CDATA", "no");
        }
        this.handler.startElement("count", atts);
        for (int i = 0; i < countErrors.length; ++i) {
            this.handler.element("error", countErrors[i]);
        }
        atts = new AttributesImpl();
        attName = "start";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getCountTimestampStart());
        attName = "end";
        atts.addAttribute("", attName, attName, "CDATA", AuditLog.getCountTimestampEnd());
        this.handler.startElement("runtime", atts);
        this.handler.endElement("runtime");
        atts = new AttributesImpl();
        attName = "nrofvotes";
        atts.addAttribute("", attName, attName, "CDATA", Integer.toString(AuditLog.getCountNrOfVotes()));
        this.handler.startElement("result", atts);
        this.handler.endElement("result");
        this.handler.endElement("count");
        this.handler.endElement("log");
    }
}

