/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import sos.koa.AuditLog;
import sos.koa.Candidate;
import sos.koa.CandidateList;
import sos.koa.KOAException;
import sos.koa.KiesKring;
import sos.koa.KiesLijst;

public class VoteSet
implements Serializable {
    private boolean my_vote_has_been_initialized;
    private boolean my_vote_has_been_finalized;
    private CandidateList my_candidate_list;
    static final /* synthetic */ boolean $assertionsDisabled;

    VoteSet(CandidateList a_candidate_list) {
        this.my_candidate_list = a_candidate_list;
    }

    final boolean validateRedundantInfo(String a_candidate_code, String a_lastname, String some_initials, String a_party_name, String a_party_number, String a_position_number) throws KOAException {
        if (!this.my_vote_has_been_initialized || this.my_vote_has_been_finalized) {
            throw new IllegalArgumentException();
        }
        Candidate candidate = this.my_candidate_list.getCandidate(a_candidate_code);
        if (!$assertionsDisabled && candidate == null) {
            throw new AssertionError();
        }
        return candidate.lastname().equals(a_lastname) && candidate.initials().equals(some_initials) && candidate.position_number() == Byte.parseByte(a_position_number) && candidate.kiesLijst().name().equals(a_party_name) && candidate.kiesLijst().number() == Byte.parseByte(a_party_number);
    }

    final boolean validateKiesKringNumber(String a_candidate_code, String a_kieskring_number) {
        if (!this.my_vote_has_been_initialized || this.my_vote_has_been_finalized) {
            throw new IllegalArgumentException();
        }
        Candidate candidate = this.my_candidate_list.getCandidate(a_candidate_code);
        if (!$assertionsDisabled && candidate == null) {
            throw new AssertionError();
        }
        return candidate.kiesKring().number() == Byte.parseByte(a_kieskring_number) && AuditLog.hasKiesKring(candidate.kiesKring().number());
    }

    final boolean validCandidate(String a_candidate_code) {
        return this.my_candidate_list.validCandidate(a_candidate_code);
    }

    final boolean validCandidate(int a_candidate_code) {
        return this.my_candidate_list.validCandidate(a_candidate_code);
    }

    final void initializeVote() {
        if (this.my_vote_has_been_initialized || this.my_vote_has_been_finalized) {
            throw new IllegalArgumentException();
        }
        this.my_vote_has_been_initialized = true;
    }

    final void addVote(String a_candidate_code) {
        if ((!this.my_vote_has_been_initialized || this.my_vote_has_been_finalized) && 0 <= Integer.parseInt(a_candidate_code) && this.validCandidate(a_candidate_code)) {
            throw new IllegalArgumentException();
        }
        Candidate candidate = this.my_candidate_list.getCandidate(a_candidate_code);
        if (!$assertionsDisabled && candidate == null) {
            throw new AssertionError();
        }
        candidate.incrementVoteCount();
        candidate.kiesLijst().incrementVoteCount();
    }

    final void addVote(int a_candidate_code) {
        if (!this.my_vote_has_been_initialized || this.my_vote_has_been_finalized) {
            throw new IllegalArgumentException();
        }
        Candidate candidate = this.my_candidate_list.getCandidate(a_candidate_code);
        if (!$assertionsDisabled && candidate == null) {
            throw new AssertionError();
        }
        candidate.incrementVoteCount();
        candidate.kiesLijst().incrementVoteCount();
    }

    final void finalizeVote() {
        if (!this.my_vote_has_been_initialized || this.my_vote_has_been_finalized) {
            throw new IllegalArgumentException();
        }
        this.my_vote_has_been_finalized = true;
    }

    final int voteCount(String a_candidate_code) {
        if (!this.my_vote_has_been_initialized || !this.my_vote_has_been_finalized) {
            throw new IllegalArgumentException();
        }
        Candidate candidate = this.my_candidate_list.getCandidate(a_candidate_code);
        return candidate.voteCount();
    }

    final int voteCount(int a_candidate_code) {
        if (!this.my_vote_has_been_initialized || !this.my_vote_has_been_finalized) {
            throw new IllegalArgumentException();
        }
        Candidate candidate = this.my_candidate_list.getCandidate(a_candidate_code);
        return candidate.voteCount();
    }

    final void resetVotes() {
        Set orderedKiesKringen = this.my_candidate_list.getKiesKringen().keySet();
        if (!$assertionsDisabled && orderedKiesKringen == null) {
            throw new AssertionError();
        }
        Iterator i = orderedKiesKringen.iterator();
        if (!$assertionsDisabled && i == null) {
            throw new AssertionError();
        }
        while (i.hasNext()) {
            Byte b = (Byte)i.next();
            KiesKring kiesKring = (KiesKring)this.my_candidate_list.getKiesKringen().get(b);
            for (int j = 0; j < kiesKring.my_kiesLijsten.length; ++j) {
                KiesLijst kiesLijst = kiesKring.my_kiesLijsten[j];
                if (kiesLijst == null) continue;
                for (int k = 0; k < kiesLijst.my_candidates.length; ++k) {
                    Candidate candidate = kiesLijst.my_candidates[k];
                    if (candidate == null) continue;
                    candidate.resetVoteCount();
                }
                kiesLijst.resetVoteCount();
            }
        }
    }

    static {
        $assertionsDisabled = !VoteSet.class.desiredAssertionStatus();
    }
}

