/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.Serializable;
import sos.koa.Candidate;
import sos.koa.KiesKring;

final class KiesLijst
implements Comparable,
Serializable {
    static final byte BLANCO = 99;
    static final byte KIESLIJST_NUMBER_MAX_LENGTH = 2;
    static final byte GROEPERING_NAME_MAX_LENGTH = 80;
    static final byte MAX_CANDIDATES_PER_KIESLIJST = 80;
    private static final KiesLijst[] MY_CACHED_KIESLIJSTEN;
    final Candidate[] my_candidates = new Candidate[81];
    private byte my_number;
    private String my_name;
    private byte my_kieskring_number;
    private byte my_candidate_count;
    private int my_vote_count;
    static final /* synthetic */ boolean $assertionsDisabled;

    private KiesLijst(byte a_kieskring_number, byte a_number, String a_name) {
        this.my_kieskring_number = a_kieskring_number;
        this.my_number = a_number;
        this.my_name = a_name;
        this.my_candidate_count = 0;
    }

    static KiesLijst make(byte a_kieskring_number, byte a_number, String a_name) {
        KiesLijst result;
        int index = a_kieskring_number * 100 + a_number;
        if (MY_CACHED_KIESLIJSTEN[index] != null && MY_CACHED_KIESLIJSTEN[index].number() == a_number && MY_CACHED_KIESLIJSTEN[index].name().equals(a_name)) {
            return MY_CACHED_KIESLIJSTEN[index];
        }
        KiesLijst.MY_CACHED_KIESLIJSTEN[index] = result = new KiesLijst(a_kieskring_number, a_number, a_name);
        return result;
    }

    byte number() {
        return this.my_number;
    }

    String name() {
        return this.my_name;
    }

    void addCandidate(Candidate a_candidate) {
        if (!$assertionsDisabled && this.my_candidates[a_candidate.position_number()] != null) {
            throw new AssertionError();
        }
        this.my_candidates[a_candidate.position_number()] = a_candidate;
        this.my_candidate_count = (byte)(this.my_candidate_count + 1);
    }

    Candidate[] candidates() {
        return this.my_candidates;
    }

    byte candidateCount() {
        return this.my_candidate_count;
    }

    int incrementVoteCount() {
        ++this.my_vote_count;
        return this.my_vote_count;
    }

    int voteCount() {
        return this.my_vote_count;
    }

    void resetVoteCount() {
        this.my_vote_count = 0;
    }

    void clear() {
        int i;
        this.my_number = 0;
        this.my_name = "";
        this.my_kieskring_number = 0;
        this.my_candidate_count = 0;
        this.my_vote_count = 0;
        for (i = 0; i < this.my_candidates.length; ++i) {
            if (this.my_candidates[i] == null) continue;
            this.my_candidates[i] = null;
        }
        for (i = 0; i < MY_CACHED_KIESLIJSTEN.length; ++i) {
            KiesLijst.MY_CACHED_KIESLIJSTEN[i] = null;
        }
    }

    public boolean equals(Object an_object) {
        if (an_object == null) {
            return false;
        }
        if (!(an_object instanceof KiesLijst)) {
            return false;
        }
        KiesLijst k = (KiesLijst)an_object;
        return k.number() == this.number() && k.name().equals(this.name()) && k.candidates().equals(this.candidates());
    }

    public int hashCode() {
        return this.my_name.hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.number() + "." + (this.number() < 10 ? "  " : " ") + this.name() + "\n");
        for (int i = 0; i < 80; ++i) {
            Candidate cand = this.candidates()[i];
            if (cand == null) continue;
            result.append(result + "candidate #" + i + ": " + cand.lastname() + "\n");
        }
        return result.toString();
    }

    public int compareTo(Object an_object) {
        if (!(an_object instanceof KiesKring)) {
            throw new ClassCastException();
        }
        KiesKring k = (KiesKring)an_object;
        return this.number() - k.number();
    }

    static {
        $assertionsDisabled = !KiesLijst.class.desiredAssertionStatus();
        MY_CACHED_KIESLIJSTEN = new KiesLijst[10101];
    }
}

