/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sos.koa.AuditLog;
import sos.koa.Hex;
import sos.koa.KOAException;
import sos.koa.MenuPanel;
import sos.koa.Task;

public class ImportVotesAdapter
extends Task {
    ArrayList rawVotes = null;
    int taskCount;
    int kieskringCount;
    boolean keepRunning;

    String getTitle() {
        return "Stemmen importeren...";
    }

    String getSuccessMessage() {
        return "Importeren is gelukt!";
    }

    String getFailureMessage() {
        return "Importeren is mislukt!";
    }

    boolean isPreStateAllowed(int state) {
        return state == 2;
    }

    int getSuccessState() {
        return 3;
    }

    boolean isCancelableTask() {
        return true;
    }

    void doAction() throws KOAException {
        this.kieskringCount = 0;
        this.taskCount = 0;
        this.keepRunning = true;
        this.rawVotes = new ArrayList();
        File file = this.popupGetFile(".xml", "Stembusbestanden (*.xml)");
        this.setMaxSubTasks((int)(2L * file.length() / 268L));
        new VoteFileChecker().check(file);
        this.setMaxSubTasks(2 * this.taskCount);
        new VoteFileParser().parse(file);
        MenuPanel.getTheMenuPanel().setRawVotes(this.rawVotes);
        this.rawVotes = null;
    }

    void stopAction() {
        this.keepRunning = false;
        this.clear();
    }

    String getInfo() {
        int voteCount = MenuPanel.getTheMenuPanel().getRawVotes().size();
        return Integer.toString(this.kieskringCount) + " kieskring" + (this.kieskringCount != 1 ? "en" : "") + " ge\u00efmporteerd!\n" + Integer.toString(voteCount) + " stem" + (voteCount != 1 ? "men" : "") + " ge\u00efmporteerd!\n";
    }

    boolean isProgressMonitoredTask() {
        return true;
    }

    void clear() {
        this.rawVotes = null;
        if (MenuPanel.getTheMenuPanel().getRawVotes() != null) {
            MenuPanel.getTheMenuPanel().setRawVotes(null);
        }
    }

    void logStarted() {
    }

    void logOpenedFile(File file) {
        Date votesFileModification = new Date(file.lastModified());
        AuditLog.setImportVotesFileName(file.toString());
        AuditLog.setImportVotesFileTimestamp(votesFileModification.toString());
    }

    void logCompleted() {
        int voteCount = MenuPanel.getTheMenuPanel().getRawVotes().size();
        AuditLog.setImportVotesSuccess(true);
        AuditLog.setImportVotesNrOfVotes(voteCount);
        AuditLog.setImportVotesNrOfKieskringen(this.kieskringCount);
    }

    void logFailed(String reason) {
        AuditLog.setImportVotesSuccess(false);
        AuditLog.setImportVotesError(reason);
    }

    class VoteFileParser
    extends DefaultHandler {
        VoteFileParser() {
        }

        private void parse(File file) throws KOAException {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                parser.parse(file, (DefaultHandler)this);
            }
            catch (SAXException se) {
                throw new KOAException(se.getMessage());
            }
            catch (Exception e) {
                throw new KOAException(e);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("GLOBAAL")) {
                AuditLog.setVotingBureau(attributes.getValue("STEMBUREAU"));
                AuditLog.setVotingChairman(attributes.getValue("VOORZITTER"));
                AuditLog.setVotingState(attributes.getValue("STATE"));
                AuditLog.setVotingElection(attributes.getValue("VERKIEZING"));
                AuditLog.setVotingElectionTimestampStart(attributes.getValue("PERIODE_START"));
                AuditLog.setVotingElectionTimestampEnd(attributes.getValue("PERIODE_EIND"));
                AuditLog.setVotingExportTimestamp(attributes.getValue("CURTIME"));
            } else if (qName.equals("KIESKRING")) {
                int kieskringNumber = Integer.parseInt(attributes.getValue("NUMMER").trim());
                String kieskringName = attributes.getValue("NAAM");
                AuditLog.addKiesKring((byte)kieskringNumber, kieskringName);
                ++ImportVotesAdapter.this.kieskringCount;
            } else if (qName.equals("ROW")) {
                if (!ImportVotesAdapter.this.keepRunning) {
                    throw new SAXException("Taak geannuleerd!");
                }
                String voteNumber = attributes.getValue("STEMNUMMER");
                String vote = attributes.getValue("STEM");
                byte[] hexVote = Hex.hexStringToBytes(vote);
                ImportVotesAdapter.this.rawVotes.add(hexVote);
                ++ImportVotesAdapter.this.taskCount;
                if (ImportVotesAdapter.this.taskCount % 100 == 0) {
                    ImportVotesAdapter.this.setSubTaskCount(ImportVotesAdapter.this.taskCount);
                }
            }
        }
    }

    class VoteFileChecker
    extends DefaultHandler {
        int reportCount = 0;
        int globaalCount = 0;
        int kieskringenCount = 0;
        int kieskringCount = 0;
        int tableCount = 0;

        VoteFileChecker() {
        }

        void check(File file) throws KOAException {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                parser.parse(file, (DefaultHandler)this);
                if (this.tableCount < 1) {
                    throw new SAXException("Geen <TABLE> tag gevonden!");
                }
            }
            catch (SAXException se) {
                throw new KOAException("Ongeldig XML formaat!");
            }
            catch (Exception e) {
                throw new KOAException(e);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("REPORT")) {
                ++this.reportCount;
                if (this.reportCount != 1) {
                    throw new SAXException("Illegale <REPORT> tag!");
                }
            } else if (qName.equals("GLOBAAL")) {
                ++this.globaalCount;
                if (this.globaalCount != 1) {
                    throw new SAXException("Illegale <GLOBAAL> tag!");
                }
            } else if (qName.equals("KIESKRINGEN")) {
                ++this.kieskringenCount;
                if (this.kieskringenCount != 1) {
                    throw new SAXException("Illegale <KIESKRINGEN> tag!");
                }
            } else if (qName.equals("KIESKRING")) {
                ++this.kieskringCount;
                if (this.kieskringCount != 1) {
                    throw new SAXException("Illegale <KIESKRING> tag!");
                }
            } else if (qName.equals("TABLE")) {
                ++this.tableCount;
                if (this.tableCount != 1) {
                    throw new SAXException("Illegale <TABLE> tag!");
                }
            } else if (qName.equals("ROW")) {
                ++ImportVotesAdapter.this.taskCount;
                if (ImportVotesAdapter.this.taskCount % 100 == 0) {
                    ImportVotesAdapter.this.setSubTaskCount(ImportVotesAdapter.this.taskCount);
                }
            } else {
                throw new SAXException("Onbekende tag: <" + qName + ">");
            }
        }
    }
}

