/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import sos.koa.AuditLog;
import sos.koa.KOAException;
import sos.koa.MenuPanel;
import sos.koa.Task;

public class ImportKeyAdapter
extends Task {
    private static final String KEY_DECRYPTION_ALGORITHM = "PBEWithMD5AndDES";
    private static final String RSA_ALGORITHM = "RSA";
    private static final byte[] SALT = new byte[]{25, 54, 120, -103, 82, 62, -22, -14};
    private static final int ITERATION_COUNT = 20;
    private int keyType;

    public ImportKeyAdapter(int keyType) {
        this.keyType = keyType;
    }

    String getTitle() {
        switch (this.keyType) {
            case 0: {
                return "Publieke sleutel importeren...";
            }
            case 1: {
                return "Private sleutel importeren...";
            }
        }
        return null;
    }

    String getSuccessMessage() {
        return "Importeren is gelukt!";
    }

    String getFailureMessage() {
        return "Importeren is mislukt!";
    }

    boolean isPreStateAllowed(int state) {
        if (this.keyType == 0) {
            return state == 4;
        }
        return state == 3;
    }

    int getSuccessState() {
        if (this.keyType == 0) {
            return 5;
        }
        return 4;
    }

    void doAction() throws KOAException {
        Key rsaKey = null;
        File keyFile = this.popupGetFile(".key", "Sleutelbestanden (*.key)");
        try {
            FileInputStream keyIn = new FileInputStream(keyFile);
            byte[] wrappedKey = new byte[keyIn.available()];
            keyIn.read(wrappedKey);
            String passwd = this.popupGetPassword();
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passwd.toCharArray());
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(SALT, 20);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(KEY_DECRYPTION_ALGORITHM);
            SecretKey pbeKey = factory.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance(KEY_DECRYPTION_ALGORITHM);
            pbeCipher.init(4, (Key)pbeKey, pbeParamSpec);
            if (this.keyType == 1) {
                rsaKey = pbeCipher.unwrap(wrappedKey, RSA_ALGORITHM, 2);
                MenuPanel.getTheMenuPanel().setPrivateKey((PrivateKey)rsaKey);
            } else if (this.keyType == 0) {
                boolean match;
                rsaKey = pbeCipher.unwrap(wrappedKey, RSA_ALGORITHM, 1);
                MenuPanel.getTheMenuPanel().setPublicKey((PublicKey)rsaKey);
                RSAPrivateKey privkey = (RSAPrivateKey)MenuPanel.getTheMenuPanel().getPrivateKey();
                boolean bl = match = privkey != null && privkey.getModulus().equals(((RSAPublicKey)rsaKey).getModulus());
                if (!match) {
                    throw new KOAException("Private en publieke sleutel\nvormen geen paar!");
                }
            }
        }
        catch (InvalidKeyException ivke) {
            throw new KOAException("Bestand bevat geen sleutel\nof verkeerde passphrase!");
        }
        catch (FileNotFoundException fnfe) {
            throw new KOAException("Bestand niet gevonden!");
        }
        catch (InvalidKeySpecException ikse) {
            throw new KOAException("Crypto bibliotheek\nondersteunt algoritme niet!");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KOAException("Crypto bibliotheek\nondersteunt algoritme niet!");
        }
        catch (NoSuchPaddingException nspe) {
            throw new KOAException("Crypto bibliotheek\nondersteunt algoritme niet!");
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new KOAException("Crypto bibliotheek\nondersteunt algoritme niet!");
        }
        catch (IOException ioe) {
            throw new KOAException(ioe);
        }
    }

    void logStarted() {
    }

    void logOpenedFile(File keyFile) {
        Date keyFileModification = new Date(keyFile.lastModified());
        if (this.keyType == 0) {
            AuditLog.setImportPubKeyFileName(keyFile.toString());
            AuditLog.setImportPubKeyFileTimestamp(keyFileModification.toString());
        } else {
            AuditLog.setImportPrivKeyFileName(keyFile.toString());
            AuditLog.setImportPrivKeyFileTimestamp(keyFileModification.toString());
        }
    }

    void logFailed(String reason) {
        if (this.keyType == 0) {
            AuditLog.setImportPubKeyError(reason);
        } else {
            AuditLog.setImportPubKeyError(reason);
        }
    }

    void logCompleted() {
        if (this.keyType == 0) {
            AuditLog.setImportPubKeySuccess(true);
            AuditLog.setKeypairSuccess(true);
        } else {
            AuditLog.setImportPrivKeySuccess(true);
        }
    }
}

