/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sos.koa.AuditLog;
import sos.koa.KOAException;
import sos.koa.MenuPanel;
import sos.koa.Task;

public class DecryptAdapter
extends Task {
    private static final byte[] SALT = new byte[]{25, 54, 120, -103, 82, 62, -22, -14};
    static final String RSA_ALGORITHM = "RSA";
    static final String DESEDE_DECRYPT_ALGORITHM = "DESede/CBC/PKCS7Padding";
    Cipher rsaCipher;
    Cipher desedeCipher;
    boolean keepRunning;
    int rowCount;
    ArrayList errors;

    public DecryptAdapter() {
        Security.insertProviderAt(new BouncyCastleProvider(), 2);
    }

    String getTitle() {
        return "Stemmen ontsleutelen...";
    }

    String getSuccessMessage() {
        if (this.errors != null && this.errors.size() > 0) {
            return "Ontsleutelen is gelukt!\n\n" + AuditLog.getImportVotesNrOfVotes() + " stem" + (AuditLog.getImportVotesNrOfVotes() != 1 ? "men" : "") + " ge\u00efmporteerd.\n" + this.errors.size() + " stem" + (this.errors.size() != 1 ? "men" : "") + " genegeerd, zie meer info!";
        }
        return "Ontsleutelen is gelukt!\n\nGeen fouten opgetreden!";
    }

    String getFailureMessage() {
        return "Ontsleutelen is mislukt!";
    }

    String getInfo() {
        return this.rowCount + " stem" + (this.rowCount != 1 ? "men" : "") + " ontsleuteld.";
    }

    boolean isPreStateAllowed(int state) {
        return state == 5;
    }

    int getSuccessState() {
        return 6;
    }

    public boolean isProgressMonitoredTask() {
        return true;
    }

    void logStarted() {
        AuditLog.setDecryptTimestampStart(AuditLog.getCurrentTimestamp());
    }

    void logFailed(String reason) {
        AuditLog.setDecryptSuccess(false);
        String[] err = new String[]{reason};
        AuditLog.setDecryptErrors(err);
    }

    void logCompleted() {
        AuditLog.setDecryptSuccess(true);
        AuditLog.setDecryptNrOfVotes(this.rowCount);
        AuditLog.setDecryptErrors(this.getErrors());
        AuditLog.setDecryptTimestampEnd(AuditLog.getCurrentTimestamp());
    }

    void doAction() throws KOAException {
        this.errors = new ArrayList();
        try {
            this.setMaxSubTasks(MenuPanel.getTheMenuPanel().getRawVotes().size());
            PrivateKey rsakey = MenuPanel.getTheMenuPanel().getPrivateKey();
            this.rsaCipher = Cipher.getInstance(RSA_ALGORITHM, "BC");
            this.rsaCipher.init(2, rsakey);
            this.desedeCipher = Cipher.getInstance(DESEDE_DECRYPT_ALGORITHM, "BC");
            ArrayList rawVotes = MenuPanel.getTheMenuPanel().getRawVotes();
            this.keepRunning = true;
            this.rowCount = 0;
            File baseDir = new File(".");
            File outDir = new File(baseDir, "tmp");
            outDir.mkdirs();
            File outFile = new File(outDir, "decrypted.txt");
            DataOutputStream decryptFile = new DataOutputStream(new FileOutputStream(outFile));
            for (int i = 0; i < rawVotes.size(); ++i) {
                if (!this.keepRunning) {
                    throw new KOAException("Taak geannuleerd!");
                }
                Object vote = rawVotes.get(i);
                if (vote instanceof byte[]) {
                    try {
                        byte[] encryptedVote = (byte[])vote;
                        String decryptedVote = this.decrypt(encryptedVote);
                        decryptFile.writeBytes(decryptedVote + "\n");
                        rawVotes.set(i, decryptedVote);
                        ++this.rowCount;
                    }
                    catch (KOAException ke) {
                        rawVotes.set(i, "DECRYPTERROR" + ke.getMessage());
                        this.errors.add("Rij index " + i + ": " + ke.getMessage());
                    }
                    catch (Exception e) {
                        rawVotes.set(i, "DECRYPTERROR" + e.getMessage());
                        this.errors.add("\nRij index " + i + ": " + e.getMessage());
                    }
                } else if (vote instanceof String) {
                    ++this.rowCount;
                }
                if (this.rowCount % 100 != 0) continue;
                this.setSubTaskCount(this.rowCount);
            }
            decryptFile.close();
        }
        catch (KOAException ke) {
            throw new KOAException(ke.getMessage());
        }
        catch (NoSuchProviderException nspre) {
            throw new KOAException("Crypto bibliotheek\nniet gevonden!");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KOAException("Crypto bibliotheek\nondersteunt algoritme niet!");
        }
        catch (InvalidKeyException ike) {
            throw new KOAException("Crypto bibliotheek\nondersteunt sleutel niet!");
        }
        catch (NoSuchPaddingException nspae) {
            throw new KOAException("Crypto bibliotheek\nondersteunt encoding niet!");
        }
        catch (Exception ex) {
            throw new KOAException("Onbekende fout");
        }
    }

    void stopAction() {
        this.keepRunning = false;
    }

    private String decrypt(byte[] encryptedVote) throws KOAException {
        try {
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(encryptedVote);
            DataInputStream dataIn = new DataInputStream(bytesIn);
            int len1 = dataIn.readInt();
            if (len1 > 1024) {
                throw new KOAException("Sessiesleutel langer dan 1024: " + len1);
            }
            byte[] wrappedSessionKey = new byte[len1];
            dataIn.read(wrappedSessionKey);
            byte[] sessionkeyData = this.rsaCipher.doFinal(wrappedSessionKey);
            byte[] desedekeyData = new byte[24];
            System.arraycopy(sessionkeyData, 39, desedekeyData, 0, 24);
            IvParameterSpec ivParamSpec = new IvParameterSpec(SALT);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("DESede", "BC");
            SecretKey desedeKey = factory.generateSecret(new DESedeKeySpec(desedekeyData));
            this.desedeCipher.init(2, (Key)desedeKey, ivParamSpec);
            int len2 = dataIn.readInt();
            if (len2 > 1024) {
                throw new KOAException("Versleutelde stem langer dan 1024: " + len2);
            }
            byte[] ciphertext = new byte[len2];
            dataIn.read(ciphertext);
            if (dataIn.read(new byte[1]) > 0) {
                throw new KOAException("Overbodige bytes gevonden in versleutelde stem");
            }
            byte[] plaintext = this.desedeCipher.doFinal(ciphertext);
            byte[] voteBytes = new byte[plaintext.length - 5];
            System.arraycopy(plaintext, 5, voteBytes, 0, voteBytes.length);
            return new String(voteBytes, "UTF-8");
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new KOAException("Crypto fout: ongeldige algoritme parameter!");
        }
        catch (NoSuchProviderException nspre) {
            throw new KOAException("Crypto fout: provider niet gevonden!");
        }
        catch (BadPaddingException bpe) {
            throw new KOAException("Crypto fout: slechte padding!");
        }
        catch (IllegalBlockSizeException ibse) {
            throw new KOAException("Crypto fout: bibliotheek ondersteunt blocksize niet!");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KOAException("Crypto fout: bibliotheek ondersteunt algoritme niet!");
        }
        catch (InvalidKeyException ike) {
            throw new KOAException("Crypto fout: bibliotheek ondersteunt sleutel niet!");
        }
        catch (InvalidKeySpecException ikse) {
            throw new KOAException("Crypto fout: bibliotheek ondersteunt sleutel niet!");
        }
        catch (IOException ioe) {
            throw new KOAException("Input/output fout!");
        }
    }

    Object getAdditionalInfo() {
        int height = Math.min(this.errors.size() + 5, 30);
        JTextArea area = new JTextArea(height, 30);
        StringBuffer additionalInfo = new StringBuffer();
        if (this.errors.size() > 0) {
            additionalInfo.append("De volgende fouten zijn geconstateerd:\n");
            for (int i = 0; i < this.errors.size(); ++i) {
                additionalInfo.append(this.errors.get(i).toString());
                additionalInfo.append("\n");
            }
        } else {
            additionalInfo.append("Er zijn geen fouten opgetreden bij het ontsleutelen.");
        }
        area.setText(additionalInfo.toString());
        area.setEditable(false);
        return new JScrollPane(area);
    }

    boolean isAdditionalInfoAvailable() {
        return true;
    }

    String[] getErrors() {
        String[] result = new String[this.errors.size()];
        this.errors.toArray(result);
        return result;
    }
}

