/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.File;
import sos.koa.AuditLog;
import sos.koa.MenuPanel;
import sos.koa.Task;

class ClearAdapter
extends Task {
    boolean systemIsCleared = false;

    ClearAdapter() {
    }

    String getTitle() {
        return "Gegevens wissen...";
    }

    String getSuccessMessage() {
        return "Wissen is gelukt!";
    }

    String getFailureMessage() {
        return "Wissen is mislukt!";
    }

    String getWarningMessage() {
        int oldFiles = 0;
        String warning = "";
        String filelist = "";
        File outDir = new File(new File("."), "tmp");
        if (outDir.exists()) {
            File auditpdf = new File(outDir, "verwerkingsverslag.pdf");
            File recountpdf = new File(outDir, "telling.pdf");
            if (auditpdf.exists()) {
                ++oldFiles;
                filelist = filelist + "\"" + auditpdf.toString() + "\"\n";
            }
            if (recountpdf.exists()) {
                ++oldFiles;
                filelist = filelist + "\"" + recountpdf.toString() + "\"\n";
            }
        }
        if (oldFiles > 0) {
            warning = "Gegevens wissen.";
            warning = warning + "\n\nDeze file" + (oldFiles == 1 ? "" : "s") + " verwijderen?\n\n";
            warning = warning + filelist + "\n";
            warning = warning + "Zeker weten?";
        } else {
            warning = "Gegevens wissen.\nZeker weten?";
        }
        return warning;
    }

    void doAction() {
        this.clearSystem();
    }

    boolean isDangerousTask() {
        return true;
    }

    boolean isPreStateAllowed(int state) {
        return state == 0;
    }

    int getSuccessState() {
        return 1;
    }

    void clearSystem() {
        MenuPanel.getTheMenuPanel().clear();
        AuditLog.clear();
        System.gc();
        ClearAdapter.clearXMLFiles();
        this.clearTXTFiles();
        this.clearPDFFiles();
        this.systemIsCleared = true;
    }

    public static void clearXMLFiles() {
        File outDir = new File(new File("."), "tmp");
        if (outDir.exists()) {
            String filelist = "";
            File auditxml = new File(outDir, "verwerkingsverslag.xml");
            File recountxml = new File(outDir, "telling.xml");
            auditxml.delete();
            recountxml.delete();
        }
    }

    public void clearTXTFiles() {
        File outDir = new File(new File("."), "tmp");
        if (outDir.exists()) {
            String filelist = "";
            File decryptedfile = new File(outDir, "decrypted.txt");
            decryptedfile.delete();
        }
    }

    private void clearPDFFiles() {
        File outDir = new File(new File("."), "tmp");
        if (outDir.exists()) {
            String filelist = "";
            File auditpdf = new File(outDir, "verwerkingsverslag.pdf");
            File recountpdf = new File(outDir, "telling.pdf");
            auditpdf.delete();
            recountpdf.delete();
        }
    }
}

