/*
 * Decompiled with CFR 0.152.
 */
package sos.koa;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import sos.koa.Candidate;
import sos.koa.CandidateListMetadata;
import sos.koa.District;
import sos.koa.KiesKring;
import sos.koa.KiesLijst;

class CandidateList
implements Serializable {
    static final byte MAX_KIESKRINGEN_PER_CANDIDATE_LIST = 100;
    SortedMap my_kieskringen;
    CandidateListMetadata my_metadata;
    private Map my_candidate_codes;
    private byte my_blanco_count;
    static final /* synthetic */ boolean $assertionsDisabled;

    CandidateList(String a_request_reference, String a_response_reference, String a_creation_time, String a_kieskring_count, String a_district_count, String a_kieslijst_count, String a_positie_count, String a_code_count) {
        this.my_metadata = new CandidateListMetadata(a_request_reference, a_response_reference, a_creation_time, Byte.parseByte(a_kieskring_count), Integer.parseInt(a_district_count), Byte.parseByte(a_kieslijst_count), Integer.parseInt(a_positie_count), Integer.parseInt(a_code_count));
        this.my_kieskringen = new TreeMap();
        this.my_candidate_codes = new HashMap(this.my_metadata.codeCount());
    }

    final KiesKring addKiesKring(byte a_kieskring_number, String a_name) {
        KiesKring kiesKring = KiesKring.make(a_kieskring_number, a_name);
        this.my_kieskringen.put(new Byte(kiesKring.number()), kiesKring);
        return kiesKring;
    }

    final District addDistrict(KiesKring a_kieskring, int a_district_number, String a_name) {
        District d = new District(a_district_number, a_name);
        a_kieskring.addDistrict(d);
        return d;
    }

    final KiesLijst addKiesLijst(KiesKring a_kieskring, byte a_kieslijst_number, String a_groepering_name) {
        KiesLijst k = KiesLijst.make(a_kieskring.number(), a_kieslijst_number, a_groepering_name);
        a_kieskring.addKiesLijst(k);
        return k;
    }

    final Candidate addCandidate(KiesKring a_kieskring, KiesLijst a_kieslijst, String a_position_number, String a_lastname, String some_initials, String a_firstname, String a_gender, String a_city_of_residence) {
        if (a_kieslijst.number() == 99 && Byte.parseByte(a_position_number) == 1) {
            this.my_blanco_count = (byte)(this.my_blanco_count + 1);
        }
        Candidate c = new Candidate(a_lastname, a_firstname, some_initials, a_gender.charAt(0), Byte.parseByte(a_position_number), a_city_of_residence, a_kieskring, a_kieslijst);
        return c;
    }

    final boolean addCandidateCode(Candidate a_candidate, String a_candidate_code) {
        return this.my_candidate_codes.put(new Integer(Integer.parseInt(a_candidate_code)), a_candidate) == null;
    }

    final Candidate getCandidate(String a_candidate_code) {
        return (Candidate)this.my_candidate_codes.get(new Integer(Integer.parseInt(a_candidate_code)));
    }

    final boolean validCandidate(String a_candidate_code) {
        return this.my_candidate_codes.containsKey(new Integer(Integer.parseInt(a_candidate_code)));
    }

    final Candidate getCandidate(int a_candidate_code) {
        return (Candidate)this.my_candidate_codes.get(new Integer(a_candidate_code));
    }

    final boolean validCandidate(int a_candidate_code) {
        return this.my_candidate_codes.containsKey(new Integer(a_candidate_code));
    }

    final CandidateListMetadata metadata() {
        return this.my_metadata;
    }

    final byte candidatesPerParty(KiesLijst a_kieslijst) {
        return a_kieslijst.candidateCount();
    }

    final byte totalPartyCount() {
        int result = 0;
        Set orderedCodes = this.my_kieskringen.keySet();
        if (orderedCodes == null) {
            return 0;
        }
        if (!$assertionsDisabled && orderedCodes == null) {
            throw new AssertionError();
        }
        Iterator i = orderedCodes.iterator();
        if (!$assertionsDisabled && i == null) {
            throw new AssertionError();
        }
        while (i.hasNext()) {
            Byte b = (Byte)i.next();
            KiesKring kiesKring = (KiesKring)this.my_kieskringen.get(b);
            result += kiesKring.kieslijstCount();
        }
        if (!$assertionsDisabled && result > 100) {
            throw new AssertionError();
        }
        return (byte)result;
    }

    final byte blancoCount() {
        return this.my_blanco_count;
    }

    final void clear() {
        if (this.my_kieskringen != null) {
            Set ordered_kieskringen = this.my_kieskringen.keySet();
            if (!$assertionsDisabled && ordered_kieskringen == null) {
                throw new AssertionError();
            }
            Iterator i = ordered_kieskringen.iterator();
            if (!$assertionsDisabled && i == null) {
                throw new AssertionError();
            }
            while (i.hasNext()) {
                Byte b = (Byte)i.next();
                KiesKring kiesKring = (KiesKring)this.my_kieskringen.get(b);
                kiesKring.clear();
            }
        }
        this.my_kieskringen.clear();
        this.my_candidate_codes.clear();
        this.my_metadata.clear();
        this.my_blanco_count = 0;
    }

    public SortedMap getKiesKringen() {
        return this.my_kieskringen;
    }

    static {
        $assertionsDisabled = !CandidateList.class.desiredAssertionStatus();
    }
}

